/* $Id: hgregexp.h,v 1.3 1997/02/28 16:20:29 bheide Exp $
 *----------------------------------------------------------------------
 *
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */

/*
 * This header file, originally from Henry Spencer, was changed by
 * Joachim Schrod <schrod@iti.informatik.th-darmstadt.de>.
 *    It may now be processed by an ANSI C compliant compiler and it may
 * be read in more than once.
 *
 * CAVEAT: If the macro ARGS is defined, it is assumed that this macro may
 * be used for the well known prototype-hiding trick. This is dirty and
 * I know it, but it works (usually). A similar comment holds for the macro
 * const to be used with non-ANSI compliant compilers.
 *
 * In fact, the package should be rewritten in ANSI C and should use
 * a (more or less `standard') configuration file which sets up respective
 * definitions. ansidecl.h from the FSF comes to mind, but it would change
 * the copyright clause in an unwished way. So, some day I'll polish my
 * portable.h and will add it to this package...
 *
 * [history at end]
 */

#ifndef hg_utils_hgregexp_h   
#define hg_utils_hgregexp_h

#include "str.h"

#define NSUBEXP  10
typedef struct hgregexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char *textStart;	/* gpani */
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} hgregexp;

extern hgregexp *regcomp (char* expression);
extern int regexec (hgregexp *prog, char *string);
extern void regsub (hgregexp *prog, char *source, char *dest);
extern void regerror (char *msg);

class HgRegexp {
public:
    HgRegexp(const char*);
    HgRegexp(const char*, int length);
    ~HgRegexp();

    int Search( char* text, int length, int index, int range);
    int Match( char* text, int length, int index);
    int Search( const RString& text, int length, int index, int range);
    int Match( const RString& text, int length, int index);
    int BeginningOfMatch( int subexp = 0);
    int EndOfMatch( int subexp = 0);
private:
    char* pattern;
    hgregexp* c_pattern;
 public:
    static int version_1_1;
};

// this is real ugly stuff :-)

inline int HgRegexp::Search( const RString& text, int length, int index, int range) {
     return Search( (char*)text.string(), length, index, range);
}

inline int HgRegexp::Match( const RString& text, int length, int index) {
     return Match( (char*) text.string(), length, index);
}

static int HgRegexp_version = HgRegexp::version_1_1;
#endif 
