// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  wer auch immer ...
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcwriter.C
// 
// Purpose:     
// 
// Created:     11 Jul 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiorpcwriter.C,v 1.2 1997/02/24 13:11:37 gorasche Exp $
// 
// $Log: tiorpcwriter.C,v $
// Revision 1.2  1997/02/24 13:11:37  gorasche
// cast for WIN32
//
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#include "tiorpcwriter.h"

#include "tifs.h"
#include "tiorpcstream.h"

#include <hyperg/utils/assert.h>
#include <hyperg/utils/environ.h>
#include <hyperg/utils/new.h>
#include <hyperg/utils/verbose.h>

// Open a connection to an RPC service at its registered host name and
// port number, or give the host name and port number needed to open a
// connection to the RPC service, or give the number of an already
// open file descriptor, or give the address of an already open
// rpcstream (connection).  Negotiate the I/O format if opening a
// connection.  Terminate the program if errors should be fatal.

TIORpcWriter::TIORpcWriter (const RString& host, int port, boolean fatal, boolean binary)
: _server(new TIOrpcstream),
  _delete(true) {
     RString address ;
     if (Environ::hostAddress (host, address)) {
        INETAddress addr (address.string(), port) ;
        if (addr) {
           TIOINETResponsePtr res 
              = TIOINETFactories::instance().connect (
                 TIOINETRequestPtr (HGNEW (TIOINETRequest (addr, 
                                                           nil /*block while connecting*/)))) ;
           hgassert (res, "TIORpcWriter::TIORpcWriter(): nil response") ;
           if (res.ptr()->io()) {
              server().attach (res.ptr()->io()) ;
              server().negotiate (binary) ;
              if (/*fucking*/!/*WinDoze*/(!/*compiler*/server()))
                 return ;
              else {
                 DEBUGNL ("TIORpcWriter::TIORpcWriter(): negotiate error") ;
              }
           }
           else {
              DEBUGNL ("TIORpcWriter::TIORpcWriter(): error response "
                       "("<<(int)res.ptr()->error()<<')') ;
           }
        }
        else {
           DEBUGNL ("TIORpcWriter::TIORpcWriter(): nix address: "<<address.string()) ;
        }
     }
     else {
        DEBUGNL ("TIORpcWriter::TIORpcWriter(): host name lookup failed") ;
     }

     // if we get here we have an error
     if (fatal)
        abort() ;
     else {
        server().clear (ios::badbit) ;
        return ;
     }
}

TIORpcWriter::TIORpcWriter (const TransparentIOPtr& tio, boolean fatal, boolean binary)
: _server(new TIOrpcstream),
  _delete(true) {
     server().attach (tio) ;
     server().negotiate (binary) ;
     
     if (!server() && fatal) {
        DEBUGNL ("TIORpcWriter::TIORpcWriter(const TransparentIOPtr&,...): negotiate() failed") ;
	abort();
     }
}

TIORpcWriter::TIORpcWriter (TIOrpcstream* server) 
: _server(server),
  _delete(false) {}

// Close the connection to the server, although the file number won't
// be closed if we attached the connection to it.  Free any storage
// allocated by RpcRegistry::find for the host name.

TIORpcWriter::~TIORpcWriter() {
   if (_delete) {
      delete _server;
   }
}

