#ifndef HW_NT_DISPATCHER

class ChildHandler;
class HANDLEArray;
class ChildLookup;

#include <stdio.h>

class NTDispatcher
{
public:
  NTDispatcher(); // window etc.
  ~NTDispatcher();

  void registerChild (HANDLE, ChildHandler*) ;
  void unregisterChild (HANDLE) ;

  // waits for some signalles objects
  int dispatch();
  int dispatch(long& sec, long& usec);

  // stops the wait
  void dropOut();

   static NTDispatcher& instance();
   static void instance(NTDispatcher*);


private:
  // HANDLE-to-ChildHandler mapping
  ChildLookup* children_ ;

  // this goes directly into a wait function
  HANDLEArray* all_handles_ ;

  // used to make the wait fall out
  HANDLE BreakEvent_;

  // holds the instance of the current scope
  static NTDispatcher* instance_;
};

#define HW_NT_DISPATCHER 1

#endif