/* Ward Christensen / CP/M parameters - Don't change these! */
/* XMODEM parameters */
#define BLOCK_SIZE  128 /* size of transmit blocks */
#define XLINE_SIZE  132 /* size of full xmodem line*/
#define OFFSET 3

typedef unsigned char byte;

typedef struct xminfo {
	int filefd;
	int portfd;
	char *fname;
	byte linebuf[XLINE_SIZE];
	int blocknum;
} XM;

int xmodem_sendfile(char *filename, int outfd);
byte xmodem_getbyte(XM *xfer);
void xmodem_sendbyte(XM *xfer, byte outbyte);
void xmodem_sendline(XM *xfer);
int xmodem_checksum(XM *xfer);
int file_readline(XM *xfer);
int xmodem_getack(XM *xfer, byte outbyte);
void xmodem_timeout(void);
