/* GiMd2Viewer - Quake2 model viewer
 * Copyright (C) 1998  Lionel ULMER <bbrox@mygale.org>
 *
 * Based on code Copyright (C) 1997 Trey Harrison <trey@crack.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MD2_H
#define MD2_H

typedef struct {
  float x, y, z;
  float nx, ny, xz;
} Vertex;

typedef struct {
  float s, t;
} TexInfo;

typedef struct {
  char name[16];
  Vertex *vert_table;
} Frame;

typedef struct {
  int32 *glcmds;	/* GL commands */
  TexInfo *texinfo;	/* texture infos */
  int32 numframes;	/* number of frames */
  Frame *frames;
  int32 skinwidth;
  int32 skinheight;
} Md2;

typedef struct {
  float x, y, z;
} Vec3;

typedef struct {
  char ident[4];
  int32 version;
  int32 skinwidth;
  int32 skinheight;
  int32 framesize;    /* byte size of each frame*/
  int32 num_skins;
  int32 num_xyz;
  int32 num_st;       /* greater than num_xyz for seams*/
  int32 num_tris;
  int32 num_glcmds;   /* dwords in strip/fan command list*/
  int32 num_frames;
  int32 ofs_skins;    /* each skin is a MAX_SKINNAME string */
  int32 ofs_st;       /* byte offset from start for stverts */
  int32 ofs_tris;     /* offset for dtriangles */
  int32 ofs_frames;   /* offset for first frame */
  int32 ofs_glcmds;
  int32 ofs_end;      /* end of file */
} Md2Header;

typedef struct {
  u_int8 x;
  u_int8 y;                /* X,Y,Z coordinate, packed on 0-255 */
  u_int8 z;
  u_int8 lightnormalindex; /* index of the vertex normal */
} Trivertex;

typedef struct {
  Vec3 scale;          /* multiply byte verts by this */
  Vec3 origin;         /* then add this */
  char name[16];       /* frame name from grabbing */
  Trivertex verts[1];  /* variable sized */
} FrameInfo;


Md2 *loadModelMd2(const char *url);
void freeModelMd2(Md2 *md2);
int getDlistModelMd2(Md2 *, int frame, int nextfrm, float inter, float scale);


#endif  /* MD2_H */
