#include <GL/gl.h>

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"
#include "parse.h"
#include "user.h"
#include "names.h"
#include "col.h"
#include "move.h"	/* userMovement */

#include "gui.h"	/* selectedObjectDeletion */
#include "zv.h"		/* setSolidBBFlag  */
#include "channel.h"	/* joinChannel */


World manager;

static const WClass end(END_TYPE, "End", NULL);


void testsolidobject(char *where, WObject *po)
{
  if (po->soh == NULL)	// not yet created
    return; 
  if (po->soh->id == 1)	// Myself
    return; 
  if (po->soh->object == NULL)
    trace(DBG_FORCE, "%s: po=%p name=%s tid=%d sid=%d sohobject=NULL",
          where, po, po->name.class_name, po->noh.type, po->soh->id);
  else
    trace(DBG_FORCE, "%s: po=%p name=%s tid=%d sid=%d sohobject=%p",
          where, po, po->name.class_name, po->noh.type, po->soh->id, po->soh->object);
}

boolean isValidType(int type_id)
{
  if (type_id < 0 || type_id >= OBJECTSNUMBER)
    return FALSE;
  return TRUE;
}

// Set the manager channel name and Join the manager channel
void setManagerChannelName(const char *chan_str)
{
  memset(manager.chan, 0, CHAN_LEN);
  strncpy(manager.chan, joinManagerChannel(chan_str), CHAN_LEN);
}

void setChannelName(const char *chan_str)
{
  if (chan_str == NULL) {
    trace(DBG_FORCE, "setChannelName: chan_str NULL");
    return;
  }
  if (*chan_str == '\0') {
    trace(DBG_FORCE, "setChannelName: chan_str EMPTY");
    return;
  }
  if (worlds)
    strcpy(worlds->chan, chan_str);
  else
    trace(DBG_FORCE, "setChannelName: worlds NULL");
}

// Get the current channel string
const char * getCurrentChannelName(void)
{
  if (worlds)
    return worlds->chan;
  else {
    trace(DBG_FORCE, "getCurrentChannelName: worlds NULL");
    return NULL;
  }
}

const char * getManagerChannelName(void)
{
  return manager.chan;
}


#ifndef VRENGD

WClass** WClass::objects_table = NULL;
int WClass::table_size = 0;

int wmgtlockstate;
boolean thisWorldIsDead = FALSE;
GeneralMethodList generalMethodList;
ObjectList *stilllist, *mobilelist, *invisiblelist, *todeletelist;
char methodname[METHODSNUMBER][HNAME_LEN];
u_int8 propertiesnumber[OBJECTSNUMBER];
float maxlasting[OBJECTSNUMBER];


// WClass constructor
WClass::WClass(int _id, const char* _name, 
	       WCreator _creator, WReplicator _replicator) 
  : type_id(_id),
    type_name(_name),
    creator(_creator),
    replicator(_replicator)
{
#if 1
  registerWClass(*this);  //a enlever plus tard
#else
  if (type_id >= table_size) {
    int new_size = type_id + 1;
    objects_table =
      (WClass**) realloc(objects_table, sizeof(WClass*) * new_size);
    for (int k = table_size; k < new_size; k++) objects_table[k] = NULL;
    table_size = new_size;
  }
  objects_table[type_id] = this;
#endif
}

void WClass::registerWClass(WClass &cl) {
#if 1
  if (cl.type_id >= table_size) {
    int new_size = cl.type_id + 1;
    objects_table =
      (WClass**) realloc(objects_table, sizeof(WClass*) * new_size);
    for (int k = table_size; k < new_size; k++) objects_table[k] = NULL;
    table_size = new_size;
  }
  objects_table[cl.type_id] = &cl;
#endif
}

const WClass* WClass::getWClass(int type_id)
{
  if (type_id < table_size)
    return objects_table[type_id];
  trace(DBG_FORCE, "getWClass: type_id=%d out of bounds", type_id);
  return NULL;
}

const WClass* WClass::getWClass(const char *type_name)
{
  for (int i=0; i < table_size; i++) {
    if (objects_table[i]
        && strcasecmp(type_name, objects_table[i]->type_name) == 0)
      return objects_table[i];
  }
  trace(DBG_FORCE, "getWClass: type_name=%s unknown", type_name);
  return NULL;
}

void WClass::creatorInstance(int type_id, char *l)
{
  if (!isValidType(type_id))
    trace(DBG_FORCE, "creatorInstance: type_id=%d out of bounds", type_id);
  else
    objects_table[type_id]->creator(l);
}

#if 0
void WClass::creatorInstance(int type_id)
{
  if (!isValidType(type_id))
    trace(DBG_FORCE, "creatorInstance: type_id=%d out of bounds", type_id);
  else
    objects_table[type_id]->creator();
}
#endif

WObject* WClass::replicatorInstance(u_int8 type_id,
				    struct _NetObjectId noid, 
				    struct _Payload *pp)
{
  if (!isValidType(type_id)) {
    trace(DBG_FORCE, "replicatorInstance: type_id=%d out of bounds", type_id);
    return NULL;
  }
  else
    return objects_table[type_id]->replicator(type_id, noid, pp);
}

#if 0
void setMethodHandler(int type_id, int action_id, void (*action_method)(void *, time_t, time_t), const char *action_name)
{
  strcpy(generalMethodList[action_id][type_id].type_name, action_name);
  generalMethodList[action_id][type_id].method = WO_HANDLER action_method;
}
#endif

void setMethodFunc(int type_id, int action_id, void (*action_method)(WObject *, void *, time_t, time_t), const char *action_name)
{
  strcpy(generalMethodList[action_id][type_id].type_name, action_name);
  generalMethodList[action_id][type_id].method = action_method;
}

WObject::WObject(void)
{
  noh.type = 0;
  noh.noid.src_id = 0;
  noh.noid.port_id = 0;
  noh.noid.obj_id = 0;
  noh.nbprop = 0;		// properties number
  noh.permanent = 0;
  noh.prop = 0;
  noh.next = NULL;

  soh = NULL;

  ptrgui = NULL;

  name.named = 0;
  name.class_name[0] = 0;
  name.given_name[0] = 0;
  name.instance_name = NULL;
  name.world_name = NULL;
  name.infos = NULL;
  name.url[0] = 0;

  pos.x = 0.0;
  pos.y = 0.0;
  pos.z = 0.0;
  pos.ax = 0.0;
  pos.ay = 0.0;
  pos.az = 0.0;

  move.perm_sec = 0;
  move.perm_usec = 0;
  move.ttl = 0.0;

  nature.collision = 0;
  nature.viscuosity = 0;
  nature.density = 0;
  nature.persistency = 0;
  nature.movable = 0;		// VR_ELEM_MOVE
  nature.selectable = 0;	// VR_SELECTABLE
  nature.bbable = 0;		// VR_BB
  nature.renderable = 0;	// VR_NORMAL_RENDER

  state.state = 0;
  state.collide = 0;
  state.ispointed = 0;
}

void initializeObject(WObject *po, int type_id, int list_id)
{
  if (!po) {
    trace(DBG_FORCE, "initializeObject: po NULL");
    return;
  }
  po->noh.type = type_id;
  updateObjectNames(po);
  if (po->noh.noid.src_id == 0) setNetObjectId((NetObject *) po);

  switch (list_id) {

  case VR_STILL:
    updateObjectIn3D(po);
    if (po->nature.bbable == VR_BB) {
      updateBB(po);
      insertObjectIntoGrid(po);
    }
    else {
      //D setSolidBBFlag(po->soh, FALSE);
      po->nature.collision = COL_NEVER;
    }
    if (po->nature.selectable == VR_SELECTABLE)
      setObjectToSolid(po);
    po->nature.movable = VR_NO_ELEM_MOVE;
    stilllist = addObjectToList(po, stilllist);
    trace(DBG_WMGT, "addObjectToStill: p=%p n=%s", po, po->name.instance_name);
    break;

  case VR_MOBILE:
    updateObjectIn3D(po);
    if (po->nature.bbable == VR_BB) {
      updateBB(po);
      insertObjectIntoGrid(po);
    }
    else {
      //D setSolidBBFlag(po->soh, FALSE);
      po->nature.collision = COL_NEVER;
    }
    if (po->nature.selectable == VR_SELECTABLE)
      setObjectToSolid(po);
    mobilelist = addObjectToList(po, mobilelist);
    trace(DBG_WMGT, "addObjectToMobile: p=%p n=%s", po, po->name.instance_name);
    break;

  case VR_INVISIBLE:
    po->nature.bbable = VR_NO_BB;
    po->nature.selectable = VR_NO_SELECTABLE;
    po->nature.movable = VR_NO_ELEM_MOVE;
    po->nature.collision = COL_NEVER;
    invisiblelist = addObjectToList(po, invisiblelist);
    break;
  }
}

const char * getObjectNameById(u_int8 type_id)
{
  const WClass *cl = WClass::getWClass(type_id);
  if (cl)
    return cl->type_name;

  warning("getObjectNameById: no name for type=%d", type_id);
  return NULL;
}

void updateObjectNames(WObject *po)
{
  if (!po) {
    trace(DBG_FORCE, "updateObjectNames: po NULL");
    return;
  }

  const char *str = getObjectNameById(po->noh.type);

  if (!str)
    return;
  strcpy(po->name.class_name, str);
  if (!po->name.named) {
    if (po->soh)
      sprintf(po->name.given_name, "%s%d", po->name.class_name, po->soh->id);
    else
      sprintf(po->name.given_name, "%s", po->name.class_name);
  }
  po->name.instance_name = po->name.given_name;
  setObjectName(po, po->name.instance_name);
  po->name.world_name = getCurrentWorldName();
}

void initializeNetObject(WObject *po, int oid, u_int8 _nbprop, u_int8 behave)
{
  if (!po) {
    trace(DBG_FORCE, "initializeNetObject: po NULL");
    return;
  }

  char str[80];

  po->noh.nbprop = _nbprop;
  propertiesnumber[po->noh.type] = _nbprop;
  sprintf(str, "%d/%d", po->noh.type, oid);
  createNetObjectFromString(&(po->noh), str, behave); /* net objname */
  trace(DBG_WMGT, "createNetObjectFromString: str=%s", str);
}

// Set the channel name and Join the new channel
void setCurrentChannelName(const char *chan_str)
{
  if (worlds)
    strcpy(worlds->chan, joinChannel(chan_str));
  else
    trace(DBG_FORCE, "setCurrentChannelName: worlds NULL");
}

// Update the World
void doWorldCalculation(time_t sec, time_t usec)
{
  ObjectList *list = NULL;

  switch (wmgtlockstate) {
  case LOCK_TOBUILD:
    warning("doWorldCalculation: no [end] encountered");

  case LOCK_DOWNLOADED:
    wmgtlockstate = LOCK_OK;
    worlds->plocaluser->move.perm_sec = sec;
    worlds->plocaluser->move.perm_usec = usec;
    clearIspointedFlag(stilllist);
    clearIspointedFlag(mobilelist);
  case LOCK_OK:

    //trace(DBG_WMGT, "doWorld:");
    //
    // do user motions
    //
    userMovement(worlds->plocaluser, sec, usec);

    //
    // do imposed objects motions
    //
    for (list = mobilelist; ((list != NULL) && (thisWorldIsDead == FALSE)); list = list->next)
      objectMovement(list->pobject, sec, usec);

    //
    // do permanent objects motions
    //
    for (list = mobilelist; list != NULL; list = list->next)
      objectPermanentMovement(list->pobject, sec, usec);

    //
    // do here special objects motions if any
    //

    //
    // delete delayed deleted objects
    //
    deleteObjects();
    thisWorldIsDead = FALSE;
  }
}

void specialRendering(void)
{
  ObjectList *list = NULL;

  for (list = mobilelist; list != NULL; list = list->next) {
    //D if (list->pobject->nature.renderable == VR_SPECIAL_RENDER) {
      renderMaterials();
      //PB glLoadName((int)list);	// needed for selection
      glPopName();
      glPushName((int)list);	// needed for selection
      list->pobject->render();
    //D }
  }
  for (list = stilllist; list != NULL; list = list->next) {
    //D if (list->pobject->nature.renderable == VR_SPECIAL_RENDER) {
      renderMaterials();
      //PB glLoadName((int)list);	// needed for selection
      glPopName();
      glPushName((int)list);	// needed for selection
      list->pobject->render();
    //D }
  }

}

// Informs a message sent by user
void userWriting(const char *usermsg)
{
  strcpy(worlds->plocaluser->message, usermsg);
  worlds->plocaluser->lastmess++;
  declareObjDelta(&(worlds->plocaluser->noh), USER_PROPMSG); /* pkt property */
}

// Call special methods for each object
void
specialAction(struct _ZVSolid *solid, int method, void *data, time_t sec, time_t usec)
{
  WObject *po = (solid==NULL) ? worlds->plocaluser : getObjectFromSolid(solid);
  if (solid && (int) solid->object < 1000) { // HACK! when objbar already stuck
    trace(DBG_FORCE, "solid corrupted");
    return;
  }
  if (po) {
    if (generalMethodList[method][po->noh.type].method != NULL)
      generalMethodList[method][po->noh.type].method(po, data, sec, usec);
  }
}

/*
 * Give instance_name or class_name and method names of an object if they exist
 * called by GUI
 */
void getObjectHumanName(Solid *solid, char **classname, char **instancename, char **actionnames)
{
  if (!solid) {
    warning("getObjectHumanName: solid NULL");
    return;
  }

  WObject *po = NULL;
  if ((po = getObjectFromSolid(solid)) == NULL) {
    *classname = *instancename = *actionnames = NULL;
    trace(DBG_WMGT, "getObjectHumanName: NULL id=%d object=%p", solid->id, solid->object);
    return;
  }

  *classname = po->name.class_name;
  *instancename = po->name.instance_name;
  *actionnames = (char *)methodname;
  trace(DBG_WMGT, "getObjectHumanName: %s:%s", *classname, *instancename);

  // find methods
  int i;
  for (i=0; generalMethodList[i][po->noh.type].type_name[0] != '\0'; i++) {
    strcpy(methodname[i], generalMethodList[i][po->noh.type].type_name);
    trace(DBG_WMGT, "getObjectHumanName: type_id=%d i=%d name=%s", po->noh.type, i, methodname[i]);
  }
  methodname[i][0] = '\0';
}

//
// Execute an object's click method if it's defined.
// Returns >0 if the method existed.
// By Mathieu Seigneurin
//
int doClickMethod(Solid *solid, V3 dir)
{
  /* Check the solid */
  if (!solid)
    return 0;

  /* Get the corresponding WObject */
  WObject *po = getObjectFromSolid(solid);
  if (!po) {
    warning("doClickMethod: unable to find WObject");
    return 0;
  }

  /* Check if the object has a click method */
  /* Execute it */
  po->click(dir);
  return 1;
}

// Delete all objects dropped in the todeletelist
void deleteObjects(void)
{
  while (todeletelist != NULL) {
    ObjectList *next = NULL;
    
    deleteObjectFromGrid(todeletelist->pobject);
    mobilelist = deleteObjectFromList(todeletelist->pobject, mobilelist);
    deleteSolidFromList(todeletelist->pobject->soh);
    todeletelist->pobject->soh = NULL;
    declareObjDeletion((NetObject*) todeletelist->pobject);
    deleteNetObject((NetObject*) todeletelist->pobject);
    selectedObjectDeletion(todeletelist->pobject->soh);
    delete todeletelist->pobject;
    next = todeletelist->next;
    free(todeletelist);
    todeletelist = next;
  }
}

// Add an object into the todeletelist
void objectToDelete(WObject *po)
{
  if (!po) {
    trace(DBG_FORCE, "objectToDelete: po NULL");
    return;
  }

  ObjectList *tmp = todeletelist;
  for ( ; tmp != NULL; tmp = tmp->next) {
    if (tmp->pobject == po)
      return;	// already deleted
  }
  todeletelist = addObjectToList(po, todeletelist);
}

#endif // !VRENGD
