#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "ball.h"	/* BALL_TYPE */
#include "dart.h"	/* DART_TYPE */
#include "bullet.h"	/* BULLET_TYPE */
#include "thing.h"	/* THING_TYPE */
#include "zv.h"		/* parseGeometry */
#include "wall.h"


const WClass Wall::wclass(WALL_TYPE, "Wall", Wall::creator);


/* wall creation from a file */
void Wall::creator(char *l)
{
  new Wall(l);
}

Wall::Wall(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  initializeObject(this, WALL_TYPE, VR_STILL);
} 

/* object intersection: projection */
void Wall::whenIntersect(WObject *pcur, WObject *pold)
{
  //TOFIX if (pcur->noh.type == BALL_TYPE) {
  //TOFIX   /* trace(DBG_FORCE, "bounce: pcur->z=%f pcur->ext.ball.origz=%f", pcur->pos.z, pcur->ext.ball.origz); */
  //TOFIX   if (ABSF(pcur->pos.z - pcur->ext.ball.origz) > 0.05) {
  //TOFIX     Pos ballold = pcur->pos;

  //TOFIX     pcur->pos.z = pcur->ext.ball.origz / 4;
  //TOFIX     pcur->pos.z = MAXI(pcur->pos.z, BALL_RADIUS);
  //TOFIX     pcur->ext.ball.origz = pcur->pos.z;
  //TOFIX     pcur->ext.ball.ttl = BALL_FLYTTL / 4;
  //TOFIX     updateReplica(pcur, ballold);
  //TOFIX   }
  //TOFIX   else
  //TOFIX     copyPositionAndBB(pold, pcur);
  //TOFIX }
  if (pcur->noh.type == BULLET_TYPE)
    objectToDelete(pcur);
  else if (pcur->noh.type == DART_TYPE)
    objectToDelete(pcur);
  else if (pcur->noh.type == THING_TYPE)
      copyPosAndBB(pold, pcur->pos);
  else { /* user */
    if (projectMovementOnObject(pcur->pos, pold->pos, pos))
      updateReplica(pcur, pold->pos);
    else
      copyPosAndBB(pold, pcur->pos);
  }
}

void wallInitFuncList(void) { }

#endif /* !VRENGD */
