#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "host.h"

#include "zv.h"		/* parseGeometry */
#include "helpers.h"


const WClass Host::wclass(HOST_TYPE, "Host", Host::creator);


/* create an host from a fileline */
void Host::creator(char *l)
{
  new Host(l);
}

Host::Host(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, HOST_TYPE, VR_STILL);
} 

/* object intersects: stop */
void Host::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

/* xterm */
static
void hostConnect(Host *po, void *data, time_t sec, time_t usec)
{
  char *host = strrchr(po->name.url, '/');

  host++;
  trace(DBG_TOOL, "Wmgt: connect to %s", host);
  startxterm(host);
}

void hostDisconnect(Host *po, void *data, time_t sec, time_t usec)
{
  quitxterm();
}

void Host::quit()
{
  quitxterm();
}

void hostInitFuncList(void)
{
  setMethodFunc(HOST_TYPE, 0, WO_ACTION hostConnect, "Connect");
  setMethodFunc(HOST_TYPE, 1, WO_ACTION hostDisconnect, "Disconnect");
}

#endif /* !VRENGD */
