#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* COL_NEVER */
#include "clock.h"

#include "zv.h"		/* parseGeometry */


const WClass Clock::wclass(CLOCK_TYPE, "Clock", Clock::creator);

static u_int16 oid = 1;


void Clock::updateTime(time_t s, time_t us, float *lasting)
{
  struct tm *pdate = localtime(&s);

  sec = pdate->tm_sec;
  min = pdate->tm_min;
  hour = pdate->tm_hour;
}

/* system of equations handling permanent motion */
void Clock::changePermanent(float lasting)
{
  switch ((ntohs(noh.noid.obj_id)) % 3) {
  case CLOCK_SECOND: /* secondes */
    pos.ax = ((float) sec * M_PI / 30.0) + M_PI_2;
    trace(DBG_WMGT, "sec=%d %f obj=%d", sec, pos.ax, noh.noid.obj_id);
    break;

  case CLOCK_MINUTE: /* minutes */
    if (min != min_last) {
      pos.ax = ((float) min * M_PI / 30.0) + M_PI_2;
      trace(DBG_WMGT, "min=%d %f obj=%d", min, pos.ax, noh.noid.obj_id);
      min_last = min;
    }
    break;

  case CLOCK_HOUR: /* hours */
    if (hour != hour_last) {
      pos.ax = ((float) hour * M_PI / 6.0) +
               ((float) min * M_PI / 360.0) + M_PI_2;
      trace(DBG_WMGT, "hour=%d %f", hour % 12, pos.ax);
      hour_last = hour;
    }
    break;
  }
}

/* create from a fileline */
void Clock::creator(char *l)
{
  new Clock(l);
}

Clock::Clock(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  nature.collision = COL_NEVER;
  nature.movable = VR_NO_ELEM_MOVE;	// else crashes in freeObjectList
  setSolidBBFlag(soh, FALSE);		// without solid BB

  initializeObject(this, CLOCK_TYPE, VR_MOBILE);
  initializeNetObject(this, oid++, CLOCK_PROPS, VR_PERMANENT);

  move.perm_sec = 1;
  move.perm_usec = 0;
  sec = min = hour = 0;
  min_last = hour_last = 255;
  float lasting = 0.0;

  updateTime(move.perm_sec, move.perm_usec, &lasting);
  changePermanent(MAXFLOAT); /* init clock */
}

/* condition to do position modifications */
boolean Clock::change()
{
  return TRUE;
}

void Clock::quit()
{
  oid = 1;
}

void clockInitFuncList(void) { }

#endif /* !VRENGD */
