#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* COL_ONCE */
#include "clip.h"

#include "zv.h"		/* parseGeometry */
#include "channel.h"	/* getvrgroup */
#include "helpers.h"	/* startmpg */


const WClass Clip::wclass(CLIP_TYPE, "Clip", Clip::creator);


/* clip initialization from a file */
void Clip::creator(char *l)
{
  new Clip(l);
}

Clip::Clip(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, CLIP_TYPE, VR_STILL);
  nature.collision = COL_ONCE;

  char *purl, *ptmpurl;

  purl = strrchr(name.url, '.');
  purl++;
  if (!strncasecmp(purl, "mpg", 3) || !strncasecmp(purl, "mpeg", 4)) {
    fmt = CLIP_FMT_MPEG;
  }
  else if (!strncasecmp(purl, "video", 5)) {
    fmt = CLIP_FMT_RTPAV;
    strcpy(url2, name.url);
    ptmpurl = strrchr(url2, '.');
    *(++ptmpurl) = '\0';
    strcpy(ptmpurl, "audio");
  }
  else if (!strncasecmp(purl, "audio", 5)) {
    fmt = CLIP_FMT_RTPAV;
    strcpy(url2, name.url);
    ptmpurl = strrchr(name.url, '.');
    *(++ptmpurl) = '\0';
    strcpy(ptmpurl, "video");
  }
  else
    trace(DBG_FORCE, "Clip: unknown media format");
} 

/* intersection: stop */
void Clip::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

static
void postCgi(const char *cmd)
{
#if HAVE_WGET
  trace(DBG_TOOL, "cmd=%s", cmd);
  switch (fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for wget");
    return;
  case 0:
    execlp("wget", "wget", "-q", cmd, (char *) NULL);
    trace(DBG_FORCE, "can't exec wget");
    exit(1);
  default:
    return;
  }
#endif
}

void Clip::startRtp()
{
  if (status == CLIP_RTP_ACTIVE)
    return;	/* busy */

  char *pfile, *end;
  pfile = strrchr(name.url, '/');
  pfile++;
  end = strchr(pfile, '.');
  *end = '\0';

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s&%s&%d&%d", CLIP_RTP_URL, CLIP_PLAY_CGI,
          pfile,
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 2,
          getCurrentTtl());
  postCgi(cmd);
  status = CLIP_RTP_ACTIVE;
}

void Clip::stopRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;	/* nothing */

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_STOP_CGI,
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 2,
          getCurrentTtl(),
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 4,
          getCurrentTtl()
         );
  postCgi(cmd);
  status = CLIP_RTP_INACTIVE;
}

void Clip::pauseRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_PAUSE_CGI,
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 2,
          getCurrentTtl(),
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 4,
          getCurrentTtl()
         );
  postCgi(cmd);
}

void Clip::contRtp()
{
  if (status == CLIP_RTP_INACTIVE)
    return;

  char cmd[URL_LEN];
  sprintf(cmd, "%s%s?%s/%d/%d&%s/%d/%d", CLIP_RTP_URL, CLIP_CONT_CGI,
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 2,
          getCurrentTtl(),
          getvrgroup(getCurrentChannelName()),
          getvrport(getCurrentChannelName()) + 4,
          getCurrentTtl()
         );
  postCgi(cmd);
}

/* play */
static
void clipStart(Clip *po, void *data, time_t sec, time_t usec)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    startmpg(po->name.url);
    break;
  case CLIP_FMT_RTPAV:
    startvideo(getCurrentChannelName());
    startaudio(getCurrentChannelName());
    po->startRtp();
    break;
  default:
    break;
  }
}

/* stop */
static
void clipStop(Clip *po, void *data, time_t sec, time_t usec)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    stopmpg();
    break;
  case CLIP_FMT_RTPAV:
    quitvideo();
    quitaudio();
    po->stopRtp();
    break;
  default:
    break;
  }
}

/* pause */
static
void clipPause(Clip *po, void *data, time_t sec, time_t usec)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    pausempg();
    break;
  case CLIP_FMT_RTPAV:
    po->pauseRtp();
    break;
  default:
    break;
  }
}

/* continue */
static
void clipCont(Clip *po, void *data, time_t sec, time_t usec)
{
  switch (po->fmt) {
  case CLIP_FMT_MPEG:
    contmpg();
    break;
  case CLIP_FMT_RTPAV:
    po->contRtp();
    break;
  default:
    break;
  }
}

void Clip::quit()
{
  status = CLIP_RTP_INACTIVE;
  this->stopRtp();
  stopmpg();
}

void clipInitFuncList(void)
{
  setMethodFunc(CLIP_TYPE, 0, WO_ACTION clipStart, "Play");
  setMethodFunc(CLIP_TYPE, 1, WO_ACTION clipStop, "Stop");
  setMethodFunc(CLIP_TYPE, 2, WO_ACTION clipPause, "Pause");
  setMethodFunc(CLIP_TYPE, 3, WO_ACTION clipCont, "Continue");
}

#endif /* !VRENGD */
