#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"
#include "cell.h"

#include "zv.h"		/* parseGeometry */
#include "gui.h"	/* selectedObjectDeletion */
#include "channel.h"	/* joinChannel quitChannel */
#include "helpers.h"


const WClass Cell::wclass(CELL_TYPE, "Cell", Cell::creator);


/* cell creation from file */
void Cell::creator(char *l)
{
  new Cell(l);
}

Cell::Cell(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  strcpy(chanin, l); l = strtok(NULL, SEP);
  strcpy(chanout, l); l = strtok(NULL, SEP);
  soh = parseGeometry(l);

  nature.collision = COL_ONCE;

  initializeObject(this, CELL_TYPE, VR_STILL);
  setSolidVisible(soh, FALSE);

  status = 0;
} 

/* through */
static
void cellMethode0(Cell *po, void *data, time_t sec, time_t usec)
{
  char *chanstr = NULL;

  if (!po->status) {
    trace(DBG_WMGT, "cell=%d %s", po->status, po->chanin);
    po->status = 1;
    quitChannel(getCurrentChannel());
    if ((chanstr = strdup(joinChannel(po->chanin))) != NULL) {
      if (audioactive) {
        quitaudio();
        startaudio(chanstr);
      }
    }
  }
  else {
    trace(DBG_WMGT, "cell=%d %s", po->status, po->chanout);
    po->status = 0;
    quitChannel(getCurrentChannel());
    if ((chanstr = strdup(joinChannel(po->chanout))) != NULL) {
      if (audioactive) {
        quitaudio();
        startaudio(chanstr);
      }
    }
  }
  if (chanstr)
    free(chanstr);
/***
  setLocalWorldName(url);
  updateMemberWorld(username, getCurrentWorldName());
***/
}

/* object intersects: gothrough */
void Cell::whenIntersect(WObject *pcur, WObject *pold)
{
  if (pold->pos.x <= pcur->pos.x)
    pcur->pos.x += (pcur->pos.bbsize.v[1] + pos.bbsize.v[1]) * 2 + CELL_GOTHROUGH;
  else
    pcur->pos.x -= (pcur->pos.bbsize.v[1] + pos.bbsize.v[1]) * 2 + CELL_GOTHROUGH;
  if (pold->pos.y <= pcur->pos.y)
    pcur->pos.y += (pcur->pos.bbsize.v[1] + pos.bbsize.v[1]) * 2 + CELL_GOTHROUGH;
  else
    pcur->pos.y -= (pcur->pos.bbsize.v[1] + pos.bbsize.v[1]) * 2 + CELL_GOTHROUGH;
  updateObjectIn3D(pcur);
  updateBB(pcur);
  /* copyPositionAndBB(pold, pcur); */

  cellMethode0(this, NULL, 0L, 0L);
}

void cellInitFuncList(void) { }

#endif /* !VRENGD */
