#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "user.h"	/* USER_TYPE */
#include "list.h"
#include "grid.h"
#include "bullet.h"

#include "zv.h"		/* parseGeometry */
#include "payload.h"	/* Payload */
#include "helpers.h"	/* playSound */


const WClass Bullet::wclass(BULLET_TYPE, "Bullet", NULL, Bullet::replicator);


/* update times */
void Bullet::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = (float) (sec - move.sec) + (float) (usec - move.usec) / 1e6;
  if (move.sec == 0) {
    *lasting = move.ttl -= BULLET_LASTING;
    move.sec = sec;
    move.usec = usec;
    return;
  }
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    move.ttl = 0;
    move.sec = move.usec = 0;

    /* the bullet has spent its time to live => destroyed */
    notice("%s destroyed", name.instance_name);
    objectToDelete(this);
  }
}

/* systeme d'equations regissant les mouvements imposes */
void Bullet::changePosition(float lasting)
{
  pos.x += lasting * move.lspeed.v[0];
  pos.y += lasting * move.lspeed.v[1];
  pos.z += lasting * move.lspeed.v[2];
  pos.az += lasting * move.aspeed.v[0];
  trace(DBG_WMGT, "bulletChangePosition: x=%.2f y=%.2f z=%.2f lasting=%.2f", pos.x, pos.y, pos.z, lasting);
}

/* condition to do position modifications */
boolean Bullet::change()
{
  return (move.ttl > 0.0005) ? TRUE : FALSE;
}

static
void bulletCreation(int methnum, User *pu, void *data, time_t sec, time_t usec)
{
  new Bullet(pu, data, sec, usec);
}

Bullet::Bullet(WObject *pu, void *data, time_t sec, time_t usec)
{
  pos.x = pu->pos.x;	//BAD + move.lspeed.v[0] * 0.2;
  pos.y = pu->pos.y;	//BAD + move.lspeed.v[1] * 0.2;
  pos.z = pu->pos.z + 0.3 * USER_DEFAULTHEIGHT;
  pos.az = pu->pos.az;
  move.perm_sec = -1;
  move.perm_usec = 0;
  lspeed = BULLET_SPEED;
  move.lspeed.v[0] = (float)(Cos((double)pu->pos.az))* lspeed;
  move.lspeed.v[1] = (float)(Sin((double)pu->pos.az))* lspeed;
  move.sec = sec;
  move.usec = usec;
  move.ttl = BULLET_TTL;

  char geom[80];
  sprintf(geom,"sphere,radius=%f,ambient=%s", BULLET_RADIUS, BULLET_COLOR);
  soh = parseGeometry(geom);

  initializeObject(this, BULLET_TYPE, VR_MOBILE);
  maxlasting[BULLET_TYPE] = BULLET_LASTING;

  noh.nbprop = BULLET_PROPS;
  propertiesnumber[BULLET_TYPE] = BULLET_PROPS;
  createNetObject((NetObject *) this, VR_VOLATILE);
  /* declareObjCreation(&(plocaluser->noh)); */
  declareObjCreation(&(this->noh));
}

/* bullet creation: this method is invisible by bullet, called by user */
void bulletCreateByUser(User *pu, void *data, time_t sec, time_t usec)
{
  bulletCreation(BULLET_CREAT, pu, data, sec, usec);
  playSound(DRIPSND);
}

/* bullet creation from the network */
WObject * Bullet::replicator(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  return new Bullet(type_id, noid, pp);
}

Bullet::Bullet(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  noh.type = type_id;
  noh.noid = noid;

  char geom[256];
  sprintf(geom, "sphere,radius=%f,ambient=%s", BULLET_RADIUS, BULLET_COLOR);
  soh = parseGeometry(geom);

  propertiesnumber[BULLET_TYPE] = BULLET_PROPS;
  initializeObject(this, BULLET_TYPE, VR_MOBILE);
  setAllProperties((NetObject *) this, pp);
  initBB(this->pos);

  lspeed = BULLET_SPEED;
  move.ttl = BULLET_TTL;
  move.perm_sec = -1;
  move.perm_usec = 0;
  playSound(DRIPSND);
}

static
void bulletSetHit(Bullet *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;

  //  getPayload(pp, "c", &(pcur->hit));
  dumpPayload(stdout, pp);

  if (pcur->hit == 1) {
    pcur->hit = 0;
    notice("%s hits me", pcur->name.instance_name);
    playSound(OUILLESND);
  }
  updateReplica(pcur, oldpos);
}

/* bullet update to the network */
boolean Bullet::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;

  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    trace(DBG_WMGT, "bulletUpdateToNetwork: x=%.2f y=%.2f", pos.x, pos.y);
    declareObjDelta(&(this->noh), BULLET_PROPXY);
    change = TRUE;
  }
  if (ABSF(pos.z - oldpos.z) > BULLET_DELTAZ)
    change = TRUE;
  if (pos.az != oldpos.az)
    change = TRUE;
#if 0 // NOT USED
  if (hit != pold->hit) {
    declareObjDelta(&(this->noh), BULLET_PROPHIT);
    trace(DBG_FORCE, "bulletUpdateToNetwork: hit=%d", hit);
    change = TRUE;
  }
#endif
  return change;
}

void Bullet::whenIntersect(WObject *pcur, WObject *pold)
{
  notice("%s intersects %s", pcur->name.instance_name, name.instance_name);
  switch (pcur->noh.type) {
  case USER_TYPE:
    /* bullet intersects an user in movement: hit */
    notice("%s hit by %s", pcur->name.instance_name, name.instance_name);
    copyPositionAndBB(pold, pcur);
    break;
  default:
    copyPositionAndBB(pold, pcur);
  }
  objectToDelete(this);	/* segfault in deleteSolidFromList */
}

void Bullet::whenWallIntersect(WObject *pold, V3 *norm)
{
  float dx, dy, dxn, dyn;
  float vx, vy, nn;
  float scalprod;

  /* We do not change the position, we only change the deltas */
  copyPositionAndBB(pold, this);

  vx = norm->v[0];
  vy = norm->v[1];
  dx = move.lspeed.v[0];
  dy = move.lspeed.v[1];

  nn = sqrt(dx*dx + dy*dy);
  dxn = dx / nn;
  dyn = dy / nn;
  scalprod = dxn * vx + dyn * vy;
  if (scalprod >= 0.0)
    return;

  move.lspeed.v[0] = (dxn - 2 * scalprod * vx) * nn;
  move.lspeed.v[1] = (dyn - 2 * scalprod * vy) * nn;
}

void bulletInitFuncList(void)
{
  setFuncList[BULLET_PROPXY][BULLET_TYPE].pf = WO_PAYLOAD set_xy;
  setFuncList[BULLET_PROPZ][BULLET_TYPE].pf = WO_PAYLOAD set_z;
  setFuncList[BULLET_PROPAZ][BULLET_TYPE].pf = WO_PAYLOAD set_az;
  setFuncList[BULLET_PROPHNAME][BULLET_TYPE].pf = WO_PAYLOAD set_hname;
  setFuncList[BULLET_PROPHIT][BULLET_TYPE].pf = WO_PAYLOAD bulletSetHit;

  getFuncList[BULLET_PROPXY][BULLET_TYPE].pf = WO_PAYLOAD get_xy;
  getFuncList[BULLET_PROPZ][BULLET_TYPE].pf = WO_PAYLOAD get_z;
  getFuncList[BULLET_PROPAZ][BULLET_TYPE].pf = WO_PAYLOAD get_az;
  getFuncList[BULLET_PROPHNAME][BULLET_TYPE].pf = WO_PAYLOAD get_hname;
  getFuncList[BULLET_PROPHIT][BULLET_TYPE].pf = WO_PAYLOAD bulletGetHit; /* user.c */

  setMethodFunc(BULLET_TYPE, BULLET_CREAT, WO_ACTION bulletCreateByUser, "");
}

#endif /* !VRENGD */
