/*
   File     : vrengd.c
   Author   : Philippe Dax
   Creation : 21/04/00
*/

#include "global.h"

#include "defaults.h"
#include "channel.h"    /* Channel */
#include "net.h"    	/* recvPacket */
#include "netdefs.h"	/* VREP */
#include "payload.h"	/* getPayload */
#include "pkt.h"	/* recvPacket */
#include "world.h"	/* setmanagerChannelName */


/*
 * Global variables
 */
u_int32 debug = 0;		/* debug flag */
int vrengd;
Universe universe;


int main(int argc, char *argv[])
{
#ifdef VRENGD
  int i, r;
  fd_set set;
  u_int8 cmd;
  struct timeval timeout;
  struct sockaddr_in sender;	/* sender unicast address */
  Payload payload;

  vrengd = TRUE;

  if (fork())
    exit(0);

  universe.ttlorigin = 127;
  // clearChannel();
  setManagerChannelName(MANAGER_CHANNEL);	/* join manager channel */

  /*
   * mainLoop
   */
  /* init sockets observation */
  for (i = 0; i < cnt_manager_fd; i++) {
    ;
  }

  /* Now ok to enter the main event loop */
  while (1) {
    FD_ZERO(&set);
    FD_SET(tab_manager_fd[0], &set);
    FD_SET(tab_manager_fd[1], &set);
    /* timeout.tv_sec = timeout.tv_usec = 0; */
    if (select(FD_SETSIZE, &set, NULL, NULL, NULL) == 0)
      continue;

    /*
     * Read the packet
     */
    if (FD_ISSET(tab_manager_fd[0], &set)) {
      if ((r = recvPacket(tab_manager_fd[0], &sender, &payload)) <= 0)
        continue;	/* read error <0 or ignore == 0 */

      /*
       * Test if this packet belongs to VREP (VREng Protocol)
       */
      if (payload.len > 0 && getPayload(&payload, "c", &cmd) >= 0) {
        /*
         * Parse VREP
         */
        switch (cmd) {
        case VREP_OBJ_CREATE:
        case VREP_OBJ_CREATE_V1:
             continue;
        case VREP_OBJ_DELTA:
        case VREP_OBJ_DELTA_V1:
             continue;
        case VREP_OBJ_QUERY:
        case VREP_OBJ_QUERY_V1:
             continue;
        case VREP_OBJ_DELETE:
        case VREP_OBJ_DELETE_V1:
             continue;
        case VREP_PERSIST_INFO:
        case VREP_PERSIST_SET:
        case VREP_PERSIST_RESET:
             incomingPersist(&sender, &payload);
             continue;
        case VREP_WORLD_INFO:
        case VREP_WORLD_SET:
        case VREP_WORLD_RESET:
             incomingWorld(&sender, &payload);
             continue;
        default:
             fprintf(stderr, "Incoming unknown cmd: X'%02x\n'", cmd);
             continue;
        }
      }
      else {
        /* empty or invalid payload */
        incomingOther(tab_manager_fd[0], &sender, &payload, r);
        continue;
      }
    }
    if (FD_ISSET(tab_manager_fd[1], &set)) {
      continue;
    }
  }
  /* NOT_REACHED */
#endif /* VRENGD */
}

