#ifndef STAT_H
#define STAT_H


/*** network counters ***/
extern u_int32 pkts_sent;
extern u_int32 sum_pkts_lost;

/*** timers ***/
typedef struct profiletime {
  struct timeval start;
  struct timeval stop;
  double cumul;
} ProfileTime;

extern ProfileTime ptime_init;
extern ProfileTime ptime_net;
extern ProfileTime ptime_events;
extern ProfileTime ptime_world;
extern ProfileTime ptime_render;
extern ProfileTime ptime_textures;
extern ProfileTime ptime_solids;
extern ProfileTime ptime_buffer;

struct _Session;

void clearTime(ProfileTime *);
void startTime(ProfileTime *);
double stopTime(ProfileTime *);
void statAdjust(void);
void statNetwork(void);
void statSendPacket(int);
void statSendRTP(int);
void statSendRTCP(int);
void statReceivePacket(int);
void statRTP(struct _Session *);
float getRate(void);


#endif /* STAT_H */
