#ifndef RTPSES_H
#define RTPSES_H

#include "rtp.h"


typedef struct _sitem {
  u_int8	type;
  u_int8	len;
  u_int8 	*str;
  struct _sitem *next;
} sdes_item;

typedef struct _sinfo {
  u_int32	ssrc;
  u_int32	extended_max;
  u_int32	expected;
  u_int32	lost;
  source	s;
  sdes_item	sdes;		/* sdes from the source, if we received it */
  rtcp_sr_t	sr;
  rtcp_rr_t	rr;
  struct _sinfo *next;
} source_info;

typedef struct _Session {	/* Informations on the session */
  u_int32	group;
  u_int16	rtp_port;
  u_int16	rtcp_port;
  u_int8	ttl;
  u_int8	type;
  rtp_hdr_t	rtp_hdr;	/* session rtp header */
  u_int16	rtp_seq;
  rtcp_sr_t	sr;
  source_info	*sinfo;	/* Informations on sources */
  u_int16	nbsources;
  sdes_item	*sdes;
  u_int8	nbsdes;	/* number of sdes_items */
  struct _Session *next;
} Session;


void RtpCreateHeader(Session *, rtp_hdr_t *, u_int32);
void RtpInitSeq(source *, u_int16);
int RtpUpdateSeq(source *, u_int16);

source_info * RtpGetSource(u_int32);
void RtpDeleteSource(Session *, u_int32);
u_int16 getNumberOfMembers(void);

const char * AvatarName(void);
const char * RtcpEmail(void);
const char * RtcpName(void);
char * ToolName(void);
char * getRtcpNameBySsrc(u_int32);
char * getRtcpEmailBySsrc(u_int32);
char * getRtcpToolBySsrc(u_int32);
char * getSdesItemBySsrc(u_int8, u_int32);
void RtpRefreshSDES(Session *);

void RtpClearSessionsList(void);
Session * RtpAllocSession(void);
struct _Channel;
u_int32 RtpCreateSession(struct _Channel *, u_int32, u_int16, u_int8);
void RtpDeleteSession(u_int32);
void RtpFreeSession(Session *);
void RtpCloseSession(Session *, u_int32);
void dumpSession(Session *);
void dumpSessions(void);
void dumpSources(void);


#endif /* RTPSES_H */
