#ifndef NETIMPL_H
#define NETIMPL_H


#define RESPONSIBLE 1
#define NOT_RESPONSIBLE 0


/*** network ids ***/
extern u_int32 my_ssrc_id;		/* ssrc network format*/
extern u_int32 my_host_id;		/* addr_IP network format */
extern u_int16 my_port_id;		/* port network format */
extern u_int16 my_obj_id;		/* id new object (naming), fmt host */
extern u_int32 my_mgr_ssrc_id;		/* manager ssrc network format*/


unsigned int random32(int type);

/*** handle noid/headers ***/
/* returns NULL if object doesn't exist
 * header vers noid se fait en lisant directement dans la struct 
 * Le nommage se fait par createNetObject ou createNetObjectFromString.
 */
NetObject * getNetObjectId(NetObjectId);
NetObject * getNetObjectsList(void);

void insertNetObject(NetObject *);

/* returns 0 if different, other if equal */
int equalNetObjectId(NetObjectId, NetObjectId);

char * getNetNameById(NetObjectId);

void initProperties(NetObject *pnoh, u_int8 responsible);

struct _Payload;
void incomingPersist(struct sockaddr_in *, struct _Payload *);
void incomingWorld(struct sockaddr_in *, struct _Payload *);
void incomingOther(int fd, struct sockaddr_in *, struct _Payload *, int len);

u_int16 RtpGetSourcesNumber(void);


#endif /* NETIMPL_H */
