/*
 * Whiteboard tool
 *
 * Philippe Dax
 * Nov 1997
 */

#ifndef VRENGD

#include "global.h"
#include "whiteboard.h"

#include "channel.h"	/* getvrgroup */


/* global variable */
int whiteboardtool = WB_TOOL;

static int whiteboardpid = -1;


static
char * getwhiteboardmc(const char *mc)
{
  u_int16 port;
  char group[GROUP_LEN];
  static char whiteboardmc[CHAN_LEN];

  port = getvrport(mc);
  port += WHITEBOARD_INCR_PORT;
  strncpy(group, getvrgroup(mc), sizeof(group));
  strncpy(whiteboardmc, createmc(group, port, getCurrentTtl()), sizeof(whiteboardmc));
  trace(DBG_TOOL, "whiteboardmc=%s", whiteboardmc);
  return(whiteboardmc);
}

void startwhiteboard(const char *mc)
{
  char *p, *ttl;
  char whiteboardmc[CHAN_LEN];

  strncpy(whiteboardmc, getwhiteboardmc(mc), sizeof(whiteboardmc));
  p = strrchr(whiteboardmc, '/');
  *p = '\0';
  ttl = ++p;
  whiteboardpid = fork();

#if defined(WIN32) && !defined(CYGWIN32) /* _spawn */
  if (whiteboardtool == WB_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "wb", "wb", "-C", "VREng-wb", "-t", ttl,
                           "-l", "+r", whiteboardmc, (char *) NULL);
  }
  if (whiteboardtool == WBD_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "wbd", "wbd", "-C", "VREng-wbd", "-t", ttl,
                            "-l", "+r", whiteboardmc, (char *) NULL);
  }
  if (whiteboardtool == NTE_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "nte", "nte", "-C", "VREng-nte", "-t", ttl,
                            whiteboardmc, (char *) NULL);
  }
#else /* WIN32 */

  switch (whiteboardpid) {
  case -1:
    trace(DBG_TOOL, "can't fork for whiteboard");
    break;
  case 0:
    if (whiteboardtool == WB_TOOL) {
      execlp("wb", "wb", "-C", "VREng-wb", "-t", ttl, "-l", "+r", whiteboardmc,
            (char *) NULL);
      trace(DBG_TOOL, "can't exec wb");
    }
    if (whiteboardtool == WBD_TOOL) {
      execlp("wbd", "wbd", "-C", "VREng-wbd", "-t", ttl, "-l", "+r", whiteboardmc,
            (char *) NULL);
      trace(DBG_TOOL, "can't exec wbd");
    }
    if (whiteboardtool == NTE_TOOL) {
      execlp("nte", "nte", "-C", "VREng-nte", "-t", ttl, whiteboardmc,
            (char *) NULL);
      trace(DBG_TOOL, "can't exec nte");
    }
    exit(1);
  default:
    break;
  }
#endif /* WIN32 */
}

void quitwhiteboard(void)
{
#ifndef WIN32 /* peut pas killer sous windows */
  if (whiteboardpid > 0)
    kill(whiteboardpid, SIGKILL);
#endif /* !WIN32 */
}

#endif /* !VRENGD */
