#ifndef VNCSOCKETS_H
#define VNCSOCKETS_H


#include <string.h>      //memset()
#include <pwd.h>         //stderr, fprintf, perror...
#include <unistd.h>      //write, close, read...
#include <errno.h>       //errno, EWOULDBLOCK...
#include <netinet/tcp.h> //TCP_NODELAY
#include <arpa/inet.h>   //inet_addr()
#include <netdb.h>       //socket(), connect()...
#include <fcntl.h>       //F_SETFL, O_NONBLOCK...


/*
 *   VNCSocket class
 */

class VNCSockets {
  
 private:
  
  //name of the server
  char ServerName[256];
  
  //port
  int port;

  //IP address of the server
  int host;

  //the used socket
  int rfbsock;

  //buffer
  unsigned int buffered;
  static const unsigned int BUF_SIZE = 8192;
  char buf[BUF_SIZE];
  char *bufoutptr;

  //stores the IP adress of the said server in host, returns false if unknown
  bool StringToIPAddr();
  
 public:

  //constructors
  VNCSockets();
  VNCSockets(char *nomServer, int Port);
  VNCSockets(unsigned int IPAddr, int Port);

  //Print out the contents of a packet for debugging.
  void PrintInHex(char *buf, int len);

  //connects to the given TCP port.
  //returns the socket if connected, -1 if connection failed
  signed int ConnectToTcpAddr();

  //Test if the other end of a socket is on the same machine.
  bool SameMachine();

  //sets a socket into non-blocking mode.
  bool SetNonBlocking();

  //Read bytes from the sever and stores it in the buffer
  bool ReadFromRFBServer(char *out, unsigned int n);

  //Write an exact number of bytes, and don't return until you've sent them.
  bool WriteExact(char *buf, int n) ;

  //get the socket used
  int GetSock();
  
};


#endif // VNCSOCKETS_H
