/*
 * Slidecast tool
 *
 * Philippe Dax
 * Sep 2000
 */

#ifndef VRENGD

#include "global.h"
#include "browsers.h"
#include "slidecast.h"

#include "channel.h"	/* getvrgroup */


/* global variable */
int slidecasttool = SLIDECAST_TOOL;

static int slidecastpid = -1;


static
char * getslidecastmc(const char *mc)
{
  u_int16 port;
  char group[GROUP_LEN];
  static char slidecastmc[CHAN_LEN];

  port = getvrport(mc);
  port += SLIDECAST_INCR_PORT;
  strncpy(group, getvrgroup(mc), sizeof(group));
  strncpy(slidecastmc, createmc(group, port, getCurrentTtl()), sizeof(slidecastmc));
  trace(DBG_TOOL, "slidecastmc=%s", slidecastmc);
  return(slidecastmc);
}

void startslidecast(const char *mc)
{
  char slidecastmc[CHAN_LEN];

  strncpy(slidecastmc, getslidecastmc(mc), sizeof(slidecastmc));
  slidecastpid = fork();

#if defined(WIN32) && !defined(CYGWIN32) /* _spawn */
  if (slidecasttool == SLIDECAST_TOOL) {
    slidecastpid = _spawnlp(_P_NOWAIT, "slide-cast", "slide-cast",
                           slidecastmc, (char *) NULL);
  }
#else /* WIN32 */

  switch (slidecastpid) {
  case -1:
    trace(DBG_TOOL, "can't fork for slidecast");
    break;
  case 0:
    if (slidecasttool == SLIDECAST_TOOL) {
      execlp("slide-cast", "slide-cast", slidecastmc, (char *) NULL);
      trace(DBG_TOOL, "can't exec slide-cast");
    }
    exit(1);
  default:
    break;
  }
#endif /* WIN32 */
}

void quitslidecast(void)
{
#ifndef WIN32 /* peut pas killer sous windows */
  if (slidecastpid > 0)
    kill(slidecastpid, SIGKILL);
#endif /* !WIN32 */
}

#endif /* !VRENGD */
