/*
 * Browser tool
 *
 * Philippe Dax
 * Nov 1997
 */

#ifndef VRENGD

#include "global.h"
#include "browsers.h"

#include "net.h"
#include "world.h"	/* getCurrentChannelName */
#include "channel.h"	/* getvrgroup */


/* global variable */
int browsertool = NETSCAPE_TOOL;
static int browserpid = -1;

static
char * getbrowsermc(void)
{
  static char chan_str[CHAN_LEN], group[GROUP_LEN];
  unsigned short port;

  port = getvrport(getCurrentChannelName());
  strncpy(group, getvrgroup(getCurrentChannelName()), sizeof(group));
  strncpy(chan_str, createmc(group, port, getCurrentTtl()), sizeof(chan_str));
  trace(DBG_TOOL, "chan_str=%s", chan_str);
  return(chan_str);
}

void startnetscape(const char *browser, const char *url)
{
  int netscapepid = -1;
  char openurl[URL_LEN];

#ifdef LAUNCHNETSCAPE
  if (browserpid < 0) {
    browserpid = fork();
    switch (browserpid) {
    case -1:
      trace(DBG_TOOL, "can't fork for %s", browser);
      break;
    case 0:
      execlp(browser, browser, url, (char *) NULL);
      trace(DBG_TOOL, "can't exec %s", browser);
      exit(1);
    default:
      break;
    }
  }
  else {
#endif
    sprintf(openurl, "openURL(%s)", url);
    netscapepid = fork();
    switch (netscapepid) {
    case -1:
      trace(DBG_TOOL, "can't fork for %s", browser);
      break;
    case 0:
      execlp(browser, browser, "-remote", openurl, (char *) NULL);
      trace(DBG_TOOL, "can't exec %s", browser);
      exit(1);
    default:
      break;
    }
#ifdef LAUNCHNETSCAPE
  }
#endif
}

void startmMosaic(const char *browser, const char *url)
{
  char *p, *ttl;
  static char mmosaicmc[CHAN_LEN];

  strncpy(mmosaicmc, getbrowsermc(), sizeof(mmosaicmc));
  p = strrchr(mmosaicmc, '/');
  *p = '\0';
  ttl = ++p;
  switch (browserpid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", browser);
    break;
  case 0:
    execlp(browser, browser, "-S", "VReng", "-t", ttl, "-mcDest", mmosaicmc, url, (char *) NULL);
    trace(DBG_TOOL, "can't exec %s", browser);
    exit(1);
  default:
    break;
  }
}

void startbrowser(const char *url)
{
  trace(DBG_TOOL, "browsertool=%d url=%s", browsertool, url);
  if (browsertool == NETSCAPE_TOOL)
    startnetscape("netscape", url);
  else if (browsertool == MMOSAIC_TOOL)
    startmMosaic("mMosaic", url);
  else trace(DBG_TOOL, "unknown browser");
}

void quitbrowser(void)
{
  if (browserpid > 0) {
    kill(browserpid, SIGKILL);
    browserpid = -1;
  }
}

#endif /* !VRENGD */
