#ifndef VRENGD

/*
 * Audio tool
 *
 * Philippe Dax
 * Oct 1997
 */

#include "global.h"
#include "audio.h"

#include "channel.h"	/* getvrgroup */


static int audiopid = -1;

/* global variable */
int audiotool = RAT_TOOL;
int audioactive = 0;


static
char * getaudiomc(const char *mc)
{
  u_int16 port;
  char group[GROUP_LEN];
  static char audiomc[CHAN_LEN];

  port = getvrport(mc);
  port += 2;
  if (port % 1)
    port++;  /* even port for RTP */
  strncpy(group, getvrgroup(mc), sizeof(group));
  strncpy(audiomc, createmc(group, port, getCurrentTtl()), sizeof(audiomc));
  trace(DBG_TOOL, "audiomc=%s", audiomc);
  return(audiomc);
}

void startaudio(const char *mc)
{
  char *p, audiomc[CHAN_LEN];
  char ttlstr[4];

  strncpy(audiomc, getaudiomc(mc), sizeof(audiomc));
  sprintf(ttlstr, "%d", getCurrentTtl());
  p = strrchr(audiomc, '/');
  *p = '\0';

#if defined(WIN32) && !defined(CYGWIN32) /* _spawn */
  if (audiotool == VAT_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "vat", "vat", "-aAsM", "-t", ttlstr,
                       "-C", "VREng", audiomc, (char *) NULL);
  }
  if (audiotool == RAT_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "rat", "rat", "-t", ttlstr,
                       "-f", "pcm", "-C", "VREng", audiomc, (char *) NULL);
  }
  if (audiotool == FPHONE_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "fphone", "fphone", "-t", ttlstr,
                       audiomc, (char *) NULL);
  }
#else /* WIN32 */ /* fork */

  switch (audiopid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for audio");
    break;
  case 0:
    if (audiotool == VAT_TOOL) {
      execlp("vat", "vat", "-aAsM", "-C", "VREng", "-t", ttlstr, audiomc,
                  (char *) NULL);
      trace(DBG_TOOL, "can't exec vat");
    }
    if (audiotool == RAT_TOOL) {
      execlp("rat", "rat", "-f", "pcm", "-C", "VREng", "-t", ttlstr, audiomc,
                  (char *) NULL);
      trace(DBG_TOOL, "can't exec rat");
    }
    if (audiotool == FPHONE_TOOL) {
      execlp("fphone", "fphone", "/T", ttlstr, audiomc, (char *) NULL);
      trace(DBG_TOOL, "can't exec fphone");
    }
    exit(1);  /* child death */
  default:
    break;
  }
#endif /* !WIN32 */
}

void quitaudio(void)
{
#ifndef WIN32 /* how to kill a process under Windows ? */
  if (audiopid > 0)
    kill(audiopid, SIGKILL);
#endif /* !WIN32 */
}

int openaudio(void)
{
  int fdaudio;

  if ((fdaudio = open(DEVAUDIO, 1)) < 0)
    perror("open devaudio");
  return fdaudio;
}

/* play a sound */
static
void * playsound(void *snd)
{
  if (audioactive)
    return NULL;

  int fdaudio;
  if ((fdaudio = openaudio()) < 0)
    return NULL;

  char *bufaudio = strdup((const char *) snd);
  int sizeaudio = decodeBase64((const char *) snd, bufaudio);

  trace(DBG_TOOL, "sizeaudio=%d on fdaudio=%d", sizeaudio, fdaudio);
  write(fdaudio, bufaudio, sizeaudio);
  close(fdaudio);
  free(bufaudio);
#if HAVE_LIBPTHREAD
  pthread_exit(NULL);
#endif
  return NULL;
}

void playSound(const char *snd)
{
#if HAVE_LIBPTHREAD
  pthread_t tid;

  pthread_create(&tid, NULL, playsound, (void *) snd);
#else
  if (fork() == 0) {
    playsound(snd);
    exit(0);
  }
#endif
}

#endif /* !VRENGD */
