/* ==================================================== ======== ======= *
 *
 *  gui.h : generic public interface for the VREng GUI
 *  NOTE: this file is common to  Athena, Motif and Ubit GUIs
 *
 *  VREng Project
 *  Author: Eric Lecolinet @ ENST Paris (elc@enst.fr)
 *  Date:   July 2000
 *
 *  WWW: http://www.enst.fr/~elc  http://www.infres.enst.fr/net/vreng/
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef GUI_H
#define GUI_H


#if WANT_GLUT
#include "glutgui.h"	/* statusLabel */
#include "glutcb.h"     /* selectedObjectDeletion */
#include "glutkeys.h"
#elif WANT_TCL
#include "tkw3d.h"	/* statusLabel */
#include "tkcb.h"	/* selectedObjectDeletion */
#include "tkkeys.h"
#else /* !WANT_GLUT && !WANT_TCL */


typedef struct vreng_resources {
  int width3D;
  int height3D;
  int maxsimcon;
  int debug;
  int histlength;
  int quality;
  char *multicast;
  char *nick;
  char *cfgpath;
  char *world;
  char *skinf;
  char *skinb;
  char *version;
} VRengResources;

void QuitVreng(int);
void initSignals(void);

  /* Resources */
extern VRengResources resources;

void GuiInitAndGetResources(int argc, char *argv[]);
  /* prend une fct. en arg. qui sera lancee apres l'ouverture de la fenetre */
void GuiMainLoop( void (*initCB)(void) );

  /*NOTE: table_no=0 for tab_fd / table_no=1 for tab_manager_fd */
void GuiAddInputTable(int table_count, int *table, int table_no);
void GuiRemoveInputTable(int table_count, int table_no);

int  GuiGetCycles(void);
void GuiWriteMessage(const char *mode, const char *from, const char *mess);
void GuiSetBusy(boolean state);	   /* sets the 'busy' cursor */
void GuiInProgess(int progress);   /* indicates work progress. value from 0 to 100 */

struct User;
void * GuiAddUser(User *);
void GuiUpdateUser(User *);
void GuiRemoveUser(User *);

struct _World;
void * GuiAddWorld(struct _World *world, boolean isCurrentWorld);
void GuiUpdateWorld(struct _World *world, boolean isCurrentWorld);
void GuiRemoveWorld(struct _World *world);

struct _ZVSolid;
void selectedObjectDeletion(struct _ZVSolid *solid);

#endif /* !WANT_GLUT && !WANT_TCL */


#endif /* GUI_H */
