#ifndef VRENGD

#include "global.h"
#include "gui.h"	/* resources */


int maxsimcon, nbsimcon;    /* Nb max and actual of simultaneous connections */
Vpthread_mutex_t nbsimcon_mutex; /* lock on the global variable simcon */
WaitFIFO *fifofirst, *fifolast; /* variables protected by nbsimcon_mutex */


void initThreads()
{
  maxsimcon = resources.maxsimcon;
  initMutex(&nbsimcon_mutex);
  nbsimcon = 0;
}

#if 0
void createThread(void *func, ThreadLaunch *tl)
{
#if defined(HAVE_LIBPTHREAD)
  Vpthread_t dummy;

  pthread_create(&dummy, NULL, func, (void *) tl);
#endif
}
#endif

void initMutex(Vpthread_mutex_t * pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_init(pmutex, NULL);
#endif
}

void lockMutex(Vpthread_mutex_t * pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_lock(pmutex);
#endif
}

void unlockMutex(Vpthread_mutex_t * pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_unlock(pmutex);
#endif
}

void beginThread(ThreadLaunch *tl)
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)
  if (tl->block == THREAD_NO_NONBLOCK) {
    trace(DBG_THRD, "-> launchThread %s", tl->url);
    /* Wait authorization to begin */
    if (tl->wait != NULL) {
      trace(DBG_THRD, "-> wait unblock %s", tl->url);
      lockMutex(&nbsimcon_mutex);
      pthread_cond_wait(&(tl->wait->cond), &nbsimcon_mutex);
      trace(DBG_THRD, "-> block %s", tl->url);

      nbsimcon++; /* update nbsimcon */
      
      /* remove element from FIFO */
      fifofirst = tl->wait->next;
      free(tl->wait);
      unlockMutex(&nbsimcon_mutex); /* free FIFO handling */
    }
  }
#endif /* WITH_PTHREAD */
}

void endThread(ThreadLaunch *tl)
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)
  if (tl->block == THREAD_NO_NONBLOCK) {
    lockMutex(&nbsimcon_mutex); /* access to global variable nbsimcon */

    nbsimcon--;

    if (fifofirst != NULL) { /* if something in FIFO, awake it */
      trace(DBG_THRD, "awake an (%d) %s", nbsimcon, tl->url);
      pthread_cond_signal(&fifofirst->cond);
    }
    unlockMutex(&nbsimcon_mutex);
  }
#endif /* WITH_PTHREAD */
}

int fifoThread(ThreadLaunch *tl)
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)
  Vpthread_t dummy;
  WaitFIFO *wf;

  lockMutex(&nbsimcon_mutex); /* access to global variable nbsimcon */
  if (nbsimcon == maxsimcon) {       /* test number of active connections */
    trace(DBG_THRD, "Nb threads: %d %s", nbsimcon, tl->url);
    wf = (WaitFIFO *) malloc(sizeof(WaitFIFO)); /* Put thread into FIFO */
    pthread_cond_init(&(wf->cond), NULL);
    wf->next = NULL;
    if (fifofirst == NULL)
      fifofirst = wf;
    if (fifolast != NULL)
      fifolast->next = wf;
    fifolast = wf;

    unlockMutex(&nbsimcon_mutex); /* unlock the global variable */
    tl->wait = wf; /* Block the thread */
    trace(DBG_THRD, "Too many threads, waiting... %s", tl->url);
  }
  else {
    /* Add a connection */
    nbsimcon++;
    trace(DBG_THRD, " -> going now (%d) %s", nbsimcon, tl->url);
    unlockMutex(&nbsimcon_mutex);
    tl->wait = NULL; /* thread not blocked */
  }

  /* Start new Thread */
  return pthread_create(&dummy, NULL, launchThread, (void *) tl);

#else
  launchThread((void *) tl);
  return 0;
#endif /* WITH_PTHREAD */
}

#endif /* !VRENGD */
