/* Shared definitions for GNU wdiff.
   Copyright (C) 1994, 1997 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef SYSDEP_H
#define SYSDEP_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/types.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <string.h>

#if HAVE_STRINGS_H
#include <strings.h>
#endif

#if HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <signal.h>
#include <math.h>
#include <errno.h>
#include <sys/stat.h>

#if HAVE_SYS_IPC_H
#include <sys/ipc.h>
#endif

#if HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#if HAVE_SYS_RESOURCE_H
# include <sys/resource.h>
#endif

#if HAVE_SYS_UTSNAME_H
# include <sys/utsname.h>
#endif

#if HAVE_SYS_SYSINFO_H
# include <sys/sysinfo.h>
#endif

#if HAVE_LIBPTHREAD
# include <pthread.h>
#endif

#if HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif
#if HAVE_SELECT_H
# include <select.h>
#endif

#if HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#if defined(WIN32) && !defined(CYGWIN32)
#include <winsock2.h>
#include <time.h>
#include <resolv.h>
#include <arpa/nameser.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#ifndef LINUX_SPARC
# include <arpa/inet.h>
#endif
#endif

#if !defined(WIN32) || !defined(MACOS)
#include <pwd.h>
#endif

#if HAVE_FLOATINGPOINT_H
#include <floatingpoint.h>
#ifdef FREEBSD
#define HAVE_FPSETMASK 1
#endif
#endif

#ifndef MAXFLOAT
#ifdef WIN32
#include <float.h>
#define MAXFLOAT FLT_MAX
#else
#define MAXFLOAT 1E100
#endif
#endif

#ifdef SUNOS
#define FORMATPTR	"%x"
#else
#define FORMATPTR	"%p"
#endif


#endif /* SYSDEP_H */
