#ifndef DEFAULTS_H
#define DEFAULTS_H

/* #undef if IP Multicast Networking else #define */
#undef STANDALONE

#ifdef STANDALONE
#define IPMC_ENABLE	0
#else
#define IPMC_ENABLE	1
#endif

/* default servers */
#ifdef STANDALONE
#define DEF_HTTP_SERVER	"localhost"
#define DEF_GNC_ADDR	"127.0.0.1"
#else
#define DEF_HTTP_SERVER	"www.infres.enst.fr"
#define DEF_GNC_ADDR	"137.194.192.1"
#endif

/* default URLs */
#define DEF_URL_PREFIX	"/net/vreng/"
#define GEN_URL(u, p) 	("http://" ## u ## p)
#define DEF_URL_CFG	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/vre/rendezvous.vre")
#define DEF_FRONT_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/default.gif")
#define DEF_BACK_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/default.1.gif")
#define DEF_BALL_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/balloon.gif")

/* default IPmc addresses & ports defined as strings */
#define DEF_VRE_UPORT	"52664"
#define DEF_VRE_MPORT	"52666"
#define DEF_VRE_TTL	"15"
#define DEF_VRE_MADDR	"224.255.0.1"
#define GEN_CHANNEL(a, p, t) (a ## "/" ## p "/" ## t)
//#define DEF_VRE_CHANNEL	"224.255.0.1/52666/15"
#define DEF_VRE_CHANNEL	GEN_CHANNEL(DEF_VRE_MADDR, DEF_VRE_MPORT, DEF_VRE_TTL)
#define MANAGER_CHANNEL	"224.255.0.0/52660/15"

#define WELCOMESTRING	"Welcome to VREng!\n"

#define DEF_WIDTH3D	480
#define DEF_HEIGHT3D	270
#define DEF_MAXSIMCON	4	/* MAX simultaneous threaded connections */


#endif /* DEFAULTS_H */
