/* A simple qt interface to add new users. */

using namespace std;

#include <QMessageBox>
#include <iostream>
#include "addUser.h"
#include "bdb_tab.h"
#include "dbclient.h"

// Global pointer to DBclient
extern DBclient* dbcp;

/* Simple constructor */
newUser::newUser(QWidget *parent) 
  : QDialog(parent) 
{
  mainUI.setupUi(this);

  // Customized signal-slot pairs
  connect(mainUI.okButton, SIGNAL(clicked()), this, SLOT(sendVal()));
  connect(mainUI.cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
}

/* Check information in the form and submit to user database.
 * Before sending the data on the form to user databse, make sure:
 * (1) Account name and passwd fields are not blank;
 * (2) Account name is unique;
 * (3) Passwd confirmation matches exactly the initial one. */
void newUser::sendVal()
{
  // Is account field blank?
  if (mainUI.account->text().isEmpty()) {
    QMessageBox::warning(0, "Error in add user form", "Account name is required.");
    return;
  }

  // Is password field blank?
  if (mainUI.passwd->text().isEmpty()) {
    QMessageBox::warning(0, "Error in add user form", "Password field is required.");
    mainUI.passwd->setFocus();
    return;
  }

  // Is password confirmation blank?
  if (mainUI.confirmation->text().isEmpty()) {
    QMessageBox::warning(0, "Error in add user form", "Password confirmation field is required.");
    mainUI.confirmation->setFocus();
    return;
  }

  // Is password and confirmation match with each other?
  if (mainUI.passwd->text() != mainUI.confirmation->text()) {
    QMessageBox::warning(0, "Error in add user form", "confirmed password doesn't match the initial one.");
    mainUI.confirmation->setFocus();
    mainUI.confirmation->selectAll();
    return;
  }

  userGUI uiData;
  string substring;
  substring = mainUI.account->text().toStdString();
  if (substring.length())
    uiData.setAccount(substring);

  substring = mainUI.name->text().toStdString();
  if (substring.length())
    uiData.setName(substring);

  substring = mainUI.phone->text().toStdString();
  if (substring.length())
    uiData.setPhone(substring);

  substring = mainUI.email->text().toStdString();
  if (substring.length())
    uiData.setEmail(substring);

  substring = mainUI.address->text().toStdString();
  if (substring.length())
    uiData.setAddress(substring);

  substring = mainUI.passwd->text().toStdString();
  if (substring.length())
    uiData.setPasswd(substring);


  // Use dynamic binding to add new user to local or remote db
  int stat = dbcp->putNewUser(uiData);
  if (stat) {
    QString tmpStr = QString::fromStdString(dbcp->getErrMsg());
    QMessageBox::warning(0, "Error in add user form", tmpStr);
    return;
  }

  QMessageBox::information(0, "User Added", "Account name " + 
			   mainUI.account->text() + " has been added successfully!");
  mainUI.account->clear();
  mainUI.name->clear();
  mainUI.phone->clear();
  mainUI.email->clear();
  mainUI.address->clear();
  mainUI.passwd->clear();
  mainUI.confirmation->clear();
}

