/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <TableView.h>

#include <Setup.h>
#include <Strings.h>
#include <TableFrame.h>
#include <DimensionDefinition.h>

#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtextstream.h>

#include <stdio.h>
#include <iostream>

using namespace std;

//----------------------------------------------------------------------------
TableView::TableView( const char* name, WFlags f )
    : GraphView( GraphView::tableView, name, f )
{
  resize(400,300);
}

//----------------------------------------------------------------------------
TableView::~TableView()
{}

//----------------------------------------------------------------------------
void TableView::save()
{
  QString fileName = QFileDialog::getSaveFileName( "", "Text file (*.txt)", this );
  if ( !fileName.isNull() )
    {
      QFile file( fileName );
      file.remove();

      if ( !file.open( IO_WriteOnly ) )
        {
          QMessageBox::warning( this, Strings::LabelApplicationName,
                                tr(Strings::MsgCouldNotWriteFile), tr(Strings::LabelOk),
                                0, 0, 0, 0);
          return;
        }

      QTextStream filestream( &file );

      QString **store = 0;
      SeriesMap::Iterator it;
      uint col = 1;
      uint rows = 0;
      uint cols = 0;
      bool firstPoint = TRUE;
      for( it = seriesMap_.begin(); it != seriesMap_.end(); ++it )
        {
          DataVector& vector = it.data();
          if ( firstPoint )
            {
              //Allocate memory for store
              cols = seriesMap_.count() + 1;
              rows = vector.getSize();
              store = new QString* [ rows ];
              for ( uint i = 0; i < rows; i++ )
                {
                  store[i] = new QString [ cols ];
                }
              //Dump frequencys
              for (uint index=0; index<vector.getSize(); index++)
                {
                  double freq = real(vector(index));
                  freq *= Setup::instance()->getDimensionValue(Strings::FrequencyDim);
                  freq /= 2*M_PI;
                  QString text;
                  text.setNum( freq, 'e', 6 );
                  store[index][0] = text;
                }
              firstPoint = false;
            }
          for (uint index=0; index<vector.getSize(); index++)
            {
              double yValue = imag(vector(index));
              QString text;
              text.setNum( yValue, 'e', 6 );
              store[index][col] = text;
            }
          col++;
        }

      for ( uint row = 0; row < rows; row++ )
        {
          for ( uint col = 0; col < cols; col++ )
            {
              filestream << store[row][col] << " ";
            }
          filestream << "\n";
        }

      for (uint i = 0; i < col;  i++)
        {
          delete [] store [i];
        }
      delete [] store;

      file.flush();
      file.close();
    }
}

//----------------------------------------------------------------------------
void TableView::draw( QPainter* )
{
  DimensionDefinition* def = Setup::instance()->getDimensionDefinition( Strings::FrequencyDim );
  //Plot each series
  bool firstPoint = true;
  SeriesMap::Iterator it;
  int col = 1;
  for( it = seriesMap_.begin(); it != seriesMap_.end(); ++it )
    {
      DataVector& vector = it.data();
      if ( firstPoint )
        {
          int x = seriesMap_.count();
          int y = vector.getSize();
          table_->setSize( y, x );
          QString label = Strings::translate( Strings::FrequencyDim );
          label += " (" + def->getActiveValueName() + ")";
          table_->setCell( 0, 0, label );
          for (uint index=0; index<vector.getSize(); index++)
            {
              double freq = real(vector(index));
              QString text;
              text.setNum( freq, 'f', 6 );
              table_->setRowHeader( index, text );
            }
          firstPoint = false;
        }
      table_->setHeader( col-1, it.key() );
      table_->setColumnWidth( col-1, 100 );
      int row = 1;
      for (uint index=0; index<vector.getSize(); index++)
        {
          double yValue = imag(vector(index));
          QString text;
          text.setNum( yValue );
          table_->setCell( row, col, text );
          row++;
        }
      col++;
    }
}

//----------------------------------------------------------------------------
void TableView::drawCursors( QPainter* )
{
  //Do nothing
}
//----------------------------------------------------------------------------
void TableView::print( QPainter * )
{
  //Do nothing
}

//----------------------------------------------------------------------------
QPoint  TableView::toClient( TReal, TReal )
{
  QPoint p( 0, 0 );
  return p;
}

//----------------------------------------------------------------------------
TComplex TableView::fromClient( int, int )
{
  TComplex p( 0, 0 );
  return p;
}

//----------------------------------------------------------------------------
TComplex TableView::transformCoordinates( TComplex )
{
  TComplex p( 0, 0 );
  return p;
}

//----------------------------------------------------------------------------
bool TableView::isInsideView( const QPoint& )
{
  return false;
}

//----------------------------------------------------------------------------
void TableView::computeScaling( QPainter* )
{
  //Do nothing
}

//----------------------------------------------------------------------------
void TableView::setDefaults()
{
  //Do nothing
}

