#ifndef TLIN4PORT_H
#define TLIN4PORT_H

#include <Component.h>

#include <qpixmap.h>

class TLin4Port : public Component
{
public:
  TLin4Port( const QPoint& center );
  virtual ~TLin4Port();

  virtual void initComponent();
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn );

  virtual const QString& getCatagory() const;
  virtual const QString& getName() const;
  virtual const QPixmap& getPixmap() const;

  virtual bool initSweep();

protected:
  virtual void drawSymbol(QPainter*);

private:
  static QPixmap* pixmap_;
  TReal z_;
  TReal e_;
  TReal f_;
};

#endif
