/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <Capacitor.h>

#include <Strings.h>

#include "../images/capacitor.xpm"

#include <iostream.h>

QPixmap* Capacitor::pixmap_ = 0;

//-----------------------------------------------------------------
Capacitor::Capacitor( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
Capacitor::~Capacitor()
{
}

//-----------------------------------------------------------------
const QString& Capacitor::getCatagory() const
{
  return Strings::LumpedCatagory;
}

//-----------------------------------------------------------------
const QString& Capacitor::getName() const
{
  return Strings::CapacitorName;
}

//-----------------------------------------------------------------
const QPixmap& Capacitor::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap(capacitor);
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void Capacitor::initComponent()
{
  boundingRect_ = QRect(-16, -8, 32, 16);
  addNode(-16,0);
  addNode(16,0);
  addAttribute( Strings::AttrCapacitance, "C" );
}

//-----------------------------------------------------------------
void Capacitor::drawSymbol(QPainter* p)
{
  p->moveTo(-16,0);
  p->lineTo(-3,0);
  p->moveTo(-3, 8);
  p->lineTo(-3, -8);
  p->moveTo(3, 8);
  p->lineTo(3,-8);
  p->moveTo(3,0);
  p->lineTo(16,0);
}

//-----------------------------------------------------------------
bool Capacitor::initSweep()
{
  TReal c = c_;
  c_ = getAttributeValue( "C" );
  c_ = c_ * getDimensionValue( Strings::CapacitanceDim );
  return (c_ != c);
}

//-----------------------------------------------------------------
void Capacitor::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  TComplex y( 0, freq*c_ );
  yn->insertComponent( y, node(0)->getNodeNumber(), node(1)->getNodeNumber() );
}
