/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <ToolBar.h>

#include <Strings.h>
#include <Setup.h>
#include <SymbolBar.h>
#include <MainWindow.h>
#include <SchematicFrame.h>

#include "images/filesave.xpm"
#include "images/fileopen.xpm"
#include "images/circuit.xpm"
#include "images/arrow.xpm"
#include "images/grid.xpm"
#include "images/rotate.xpm"
#include "images/line.xpm"
#include "images/text.xpm"
#include "images/sweep.xpm"
#include "images/delete.xpm"

#include <qlabel.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include <qiconset.h>

#include <iostream.h>

ToolBar* ToolBar::instance_ = 0;

//-----------------------------------------------------------------
ToolBar::ToolBar(const QString & label, QMainWindow* mainWindow, QMainWindow::ToolBarDock dock, bool newLine)
  : QToolBar(label, mainWindow, dock, newLine, Strings::ToolBarName),
    selectEnabled_( FALSE ),
    catagoryBox_(0)
{
  ASSERT( instance_ == 0 );
  instance_ = this;
}

//-----------------------------------------------------------------
ToolBar::~ToolBar()
{
  instance_ = 0;
}

//-----------------------------------------------------------------
ToolBar* ToolBar::instance()
{
  return instance_;
}

//-----------------------------------------------------------------
void ToolBar::initialize()
{
  QPixmap openIcon(fileopen);
  QString loadButtonName = Strings::translate( Strings::TooltipOpenFile);
  new QToolButton(openIcon, loadButtonName, 0,
		  MainWindow::instance() , SLOT( loadSlot() ),
		  this, "open file" );
  
  QPixmap saveIcon(filesave);
  QString saveButtonName = Strings::translate( Strings::TooltipSaveFile);
  new QToolButton( saveIcon, saveButtonName, 0,
		   MainWindow::instance() , SLOT( saveSlot() ),
		   this, "save file" );

  insertSeparator();

  QPixmap sweepIcon(sweep_xpm);
  QString sweepButtonName = Strings::translate( Strings::TooltipSweepCircuit);
  new QToolButton( sweepIcon, sweepButtonName, 0,
		   this, SLOT( sweepCircuitSlot() ),
		   this, "sweep" );

  insertSeparator();

  QPixmap circuit(circuit_xpm);
  QString circuitButtonName = Strings::translate( Strings::TooltipNewSchematic);
  new QToolButton( circuit, circuitButtonName, 0,
		   MainWindow::instance() , SLOT( newSchematicSlot() ),
		   this, "new sub circuit" );

  insertSeparator();

  QPixmap arrowIcon(arrow);
  QString placeButtonName = Strings::translate( Strings::TooltipPlaceSymbol);
  arrowTool_ = new QToolButton( arrowIcon, placeButtonName, 0,
				this, SLOT( toggleSelectionSlot() ),
				this, "place symbol" );
  arrowTool_->setToggleButton(true);
  
  QPixmap lineIcon(line_xpm);
  QString lineButtonName = Strings::translate( Strings::TooltipLineSymbol);
  lineTool_ = new QToolButton( lineIcon, lineButtonName, 0,
			       this, SLOT( toggleLineSlot() ),
			       this, "place symbol" );
  lineTool_->setToggleButton(true);
  

  QPixmap gridIcon(grid);
  QString gridButtonName = Strings::translate( Strings::TooltipToggleGrid);
  gridTool_ = new QToolButton( gridIcon, gridButtonName, 0,
			       this , SLOT( toggleGridSlot() ),
			       this, "toggle grid" );
  gridTool_->setToggleButton(true);

  QPixmap textIcon(text_xpm);
  QString textButtonName = Strings::translate( Strings::TooltipToggleText);
  textTool_ = new QToolButton( textIcon, textButtonName, 0,
			       this , SLOT( toggleComponentTextSlot() ),
			       this, "toggle text" );
  textTool_->setToggleButton(true);
  textTool_->setOn( true );

  QPixmap rotatePixmap(rotate);
  QIconSet rotateIcon(rotatePixmap);
  QString rotateButtonName = Strings::translate( Strings::TooltipRotateSymbol);
  rotateTool_ =  new QToolButton( rotateIcon, rotateButtonName, 0,
				  this, SLOT( rotateSymbolSlot() ),
				  this, "rotate" );
  rotateTool_->setEnabled( FALSE );  //initially nothing will have been selected

  QPixmap deletePixmap(delete_xpm);
  QIconSet deleteIcon(deletePixmap);
  QString deleteButtonName = Strings::translate(Strings::TooltipDeleteSymbol);
  deleteTool_ =  new QToolButton( deleteIcon, deleteButtonName, 0,
				  this, SLOT( deleteSlot() ),
				  this, "delete" );
  deleteTool_->setEnabled( FALSE );  //initially nothing will have been selected
  
  insertSeparator();
  
  catagoryBox_ = new QComboBox( FALSE, this, "read-only combo" );
  addSeparator();

  connect( catagoryBox_, SIGNAL( activated( int ) ),
	   this, SLOT( newCatagorySelectedSlot( int ) ) );

}

//-----------------------------------------------------------------
void ToolBar::insertSeparator()
{
  addSeparator();
}

//-----------------------------------------------------------------
void ToolBar::addComponentCatagory(const QString& catagory)
{
  catagoryBox_->insertItem(catagory);
  SymbolBar::instance()->newComponentCatagorySelected( catagoryBox_->currentText() );
}

//-----------------------------------------------------------------
void ToolBar::newCatagorySelectedSlot( int index )
{
  SymbolBar::instance()->newComponentCatagorySelected( catagoryBox_->text( index ) );
}

//-----------------------------------------------------------------
void ToolBar::toggleGridSlot()
{
  SchematicFrame::instance()->toggleGrid();
}

//-----------------------------------------------------------------
void ToolBar::toggleComponentTextSlot()
{
  Setup::instance()->setComponentTextEnabled(textTool_->isOn());
  SchematicFrame::instance()->reDraw();
}

//-----------------------------------------------------------------
bool ToolBar::isEditingMode() const
{
  return selectEnabled_;
}

//-----------------------------------------------------------------
bool ToolBar::isDrawingMode() const
{
  return drawEnabled_;
}

//-----------------------------------------------------------------
void ToolBar::toggleSelectionSlot()
{
  if ( lineTool_->isOn() )
    {
      drawEnabled_ = FALSE;
      lineTool_->toggle();
    }
  selectEnabled_ = !selectEnabled_;
}

//-----------------------------------------------------------------
void ToolBar::toggleLineSlot()
{
  if ( arrowTool_->isOn() )
    {
      selectEnabled_ = FALSE;
      arrowTool_->toggle();
    }
  drawEnabled_ = !drawEnabled_;
}

//-----------------------------------------------------------------
void ToolBar::rotateSymbolSlot()
{
  SchematicFrame::instance()->rotateSelectedComponent();
}

//-----------------------------------------------------------------
void ToolBar::sweepCircuitSlot()
{
  MainWindow::instance()->calculateResponse();
}

//-----------------------------------------------------------------
void ToolBar::deleteSlot()
{
  SchematicFrame::instance()->deleteSelectedItemSlot();
}

//-----------------------------------------------------------------
void ToolBar::popupToggleLineSlot()
{
  //first toggle icon on toolbar & then complete action
  lineTool_->toggle();
  toggleLineSlot();
}

//-----------------------------------------------------------------
void ToolBar::popupSelectionSlot()
{
  //first toggle icon on toolbar & then complete action
  arrowTool_->toggle();
  toggleSelectionSlot();
}

//-----------------------------------------------------------------
void ToolBar::updateToolbarIcons() const
{
  bool enableIcons = SchematicFrame::instance()->anythingSelected();
  rotateTool_->setEnabled(enableIcons);
  deleteTool_->setEnabled(enableIcons);
}

