/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <SubstrateDefinition.h>

#include <Utils.h>
#include <Strings.h>

#include <qdom.h>
#include <qtextstream.h>

//----------------------------------------------------------------------------
SubstrateDefinition::SubstrateDefinition()
  :  hasChanged_( TRUE ),
     type_( stripline ),
     er_( 4.51 ),
     h_( 0 ),
     t_( 0 ),
     rho_( 0 )
{
}
    
//----------------------------------------------------------------------------
SubstrateDefinition::~SubstrateDefinition()
{
}

//----------------------------------------------------------------------------
bool SubstrateDefinition::changed() const
{
  return hasChanged_; 
}

//----------------------------------------------------------------------------
void SubstrateDefinition::clearChanged()
{
  hasChanged_ = FALSE;
}

//----------------------------------------------------------------------------
SubstrateDefinition::SubstrateType SubstrateDefinition::type() const
{
  return type_;
}

//----------------------------------------------------------------------------
TReal SubstrateDefinition::er() const
{
  return er_;
}

//----------------------------------------------------------------------------
TReal SubstrateDefinition::height() const
{
  return h_;
}

//----------------------------------------------------------------------------
TReal SubstrateDefinition::thickness() const
{
  return t_;
}

//----------------------------------------------------------------------------
TReal SubstrateDefinition::rho() const
{
  return rho_;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::setType( SubstrateType type )
{
  type_ = type;
  hasChanged_ = TRUE;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::setEr( TReal er )
{
  ASSERT( er > 0 );
  er_ = er;
  hasChanged_ = TRUE;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::setHeight( TReal h )
{
  ASSERT( h > 0 );
  h_ = h;
  hasChanged_ = TRUE;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::setThickness( TReal t )
{
  ASSERT( t > 0 );
  t_ = t;
  hasChanged_ = TRUE;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::setRho( TReal rho)
{
  ASSERT( rho > 0 );
  rho_ = rho;
  hasChanged_ = TRUE;
}

//----------------------------------------------------------------------------
void SubstrateDefinition::writeToStream( const QString& name,
					 QTextStream& stream )
{
  stream << "<SUB NAME=\"" << name << "\" TYPE=\"";
  stream << (uint) type_ << "\" ER=\"";
  stream << er_ << "\" H=\"";
  stream << h_ << "\" T=\"";
  stream << t_ << "\" RHO=\"";
  stream << rho_ << "\" />" << endl;
}

//----------------------------------------------------------------------------
bool SubstrateDefinition::readFromDOM( QDomElement& element )
{
  QString typeStr = element.attribute( "TYPE" );
  QString erStr = element.attribute( "ER" );
  QString hStr = element.attribute( "H" );
  QString tStr = element.attribute( "T" );
  QString rhoStr = element.attribute( "RHO" );
				  
  type_ = ( SubstrateDefinition::SubstrateType ) typeStr.toUInt();
  er_ = erStr.toDouble();
  h_ = hStr.toDouble();
  t_ = tStr.toDouble();
  rho_ = rhoStr.toDouble();
  
  return TRUE;
}
