#include <ComponentFactory.h>

#include <Strings.h>
#include <Vccs.h>
#include <Gyrator.h>
#include <Component.h>
#include <Resistor.h>
#include <Inductor.h>
#include <InductorQ.h>
#include <Capacitor.h>
#include <TLin2Port.h>
#include <TLin4Port.h>
#include <TLinPhysical.h>
#include <CLin.h>
#include <SignalGnd.h>
#include <SignalPort.h>
#include <Block1Port.h>
#include <Block2Port.h>

#include <qpoint.h>
#include <qstring.h>

Component* ComponentFactory::createComponent( const QString& name ,
					      const QPoint& center )
{
  Component* component = 0;
  if ( name == Strings::ResistorName )
    {
      component = new Resistor( center );
    }
  else if ( name == Strings::CapacitorName )
    {
      component = new Capacitor( center );
    }
  else if ( name == Strings::InductorName )
    {
      component = new Inductor( center );
    }
  else if ( name == Strings::InductorQName )
    {
      component = new InductorQ( center );
    }
  else if ( name == Strings::VccsName )
    {
      component = new Vccs( center );
    }
  else if ( name == Strings::GyratorName )
    {
      component = new Gyrator( center );
    }
  else if ( name == Strings::TLin2PortName )
    {
      component = new TLin2Port( center );
    }
  else if ( name == Strings::TLin4PortName )
    {
      component = new TLin4Port( center );
    }
  else if ( name == Strings::TLinPhysicalName )
    {
      component = new TLinPhysical( center );
    }
  else if ( name == Strings::CLinName )
    {
      component = new CLin( center );
    }
  else if ( name == Strings::SignalPortName )
    {
      component = new SignalPort( center );
    }
  else if ( name == Strings::SignalGndName )
    {
      component = new SignalGnd( center );
    }
  else if ( name == Strings::Block1PortName )
  {
      component = new Block1Port( center );
    }
  else if ( name == Strings::Block2PortName )
    {
      component = new Block2Port( center );
    }
  ASSERT( component != 0 );
  return component;
}
