#ifndef _POS_H_
#define _POS_H_
/*
**
**  POS -- Perl-like Operations and Structures
**
*/

#include "vstring.h"

#define ASSERT(e)  { if (!(e)) { printf( "ASSERT FAIL in %s on line %s, %s\n", __FILE__, __LINE__, #e ); exit(-1); }
  
/* StrRE *******************************************************************/

struct VRegExp
{
  /* private */

  /* public */
  
  StrRE();
  ~StrRE();

}

/* VArray ******************************************************************/

struct VArray
{
  /* private */

  int _max_len;
  int _min_len;
  int _cnt;
  
  char** _data;
  
  /* public */
  
  StrArray();
  ~StrArray();
  
  /* statistics */
  
  int cnt() { return _cnt };
  int max_len() { return _max_len };
  int min_len() { return _min_len };
  
  /* casts */
  
  const char* operator[] ( int n ) { return get(n) };
  const int   operator[] ( int n ) { return atoi(get(n)) };
  const long  operator[] ( int n ) { return atol(get(n)) };
  
  /* methods */
  const char* get( int n );
  void set( int n, const char* s );
  
  int push( const char* s ); /* return number of the new elements */
  int push( const int i );
  int push( const long l );
  
  
  
}  

/* VHash *******************************************************************/
  
#endif//_POS_H_
