/*
 *           Vertex Model Assembler: V3D Primitives Palette
 */

#ifndef PRIMPALETTE_H
#define PRIMPALETTE_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "v3dmp.h"

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	V3D Primitives Palette item structure:
 */
typedef struct {

	gint type;		/* One of V3DMP_TYPE_*. */
	gint width, height;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	char *description;	/* Tool tip description. */
	void *p;		/* Unrealized referance primitive. */

} vma_primitives_palette_item_struct;

/*
 *	V3D Primitives Palette structure:
 */
typedef struct {

	gbool initialized;

	void *core_ptr;		/* Pointer back to core. */
	void *editor_ptr;	/* Pointer back to editor (if any). */

	GdkGC *gc_fg;
	GdkGC *gc_bg;
	GdkGC *gc_selected_fg;
	GdkGC *gc_selected_bg;
	GdkGC *gc_insensitive_bg;

	GtkWidget *toplevel;	/* An hbox. */
	GtkWidget *palette;	/* A GtkDrawingArea */

	vma_primitives_palette_item_struct **item;
	gint selected_item, motion_item, total_items;

	GtkAdjustment *adj;	/* Scroll position. */

	guint scroll_toid;	/* (guint)(-1) for none. */

	gpointer client_data;
	void (*select_cb)(
		gpointer,	/* client_data */
		gint		/* Index number of item. */
	);
	void (*create_cb)(
		gpointer,       /* client_data */
		gint,		/* Primitive type, V3DMP_TYPE_*. */
		gpointer	/* Referance primitive. */
	);

} vma_primitives_palette_struct;


extern vma_primitives_palette_struct *VMAPrimPaletteNew(
	void *core_ptr, void *editor_ptr,
	GdkWindow *window,
	gpointer client_data,
	void (*select_cb)(gpointer, gint),
	void (*create_cb)(gpointer, gint, gpointer)
);
extern void VMAPrimPaletteSensitivity(
	vma_primitives_palette_struct *pp, gbool sensitivity
);
extern void VMAPrimPaletteDelete(vma_primitives_palette_struct *pp);


#endif	/* PRIMPALETTE_H */
