/*
                    Pair of reorderable stack lists
 */

#ifndef STACKLIST_H
#define STACKLIST_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Stack list item structure:
 */
typedef struct {

	gchar *name;
	gchar *description;
	GdkPixmap *icon_pixmap;
	GdkBitmap *icon_mask;

        gpointer client_data;
        gint id;			/* Arbitary number used to match
					 * this item.
					 */ 

	gbool allow_multiple;		/* If TRUE then multiple instances of
					 * this item on the target list are
					 * allowed.
					 */

	gbool stay_on_target;		/* If TRUE then this item may not be
					 * removed from the target list.
					 */

} stack_list_item_struct;

#define STACK_LIST_ITEM(p)	((stack_list_item_struct *)(p))


/*
 *	Stack list structure:
 */
typedef struct {

	GtkWidget *toplevel;

	GtkWidget *src_clist, *tar_clist;
	GtkWidget *left_arrow_btn, *right_arrow_btn;
	GtkWidget *up_arrow_btn, *down_arrow_btn;
	gint src_last_selected, tar_last_selected;
	GtkWidget *description_label;

	GtkWidget	*src_menu,
			*src_add_mi,
			*src_remove_mi;
	GtkWidget	*tar_menu,
			*tar_add_mi,
			*tar_remove_mi,
			*tar_up_mi,
			*tar_down_mi;

	/* Main cache of items. */
	stack_list_item_struct **item;
	gint total_items;

	/* Last description label displayed for this item pointer,
	 * can be NULL and should never be assumed to be valid!
	 */
	stack_list_item_struct *last_description_item;

	/* Callbacks, input are:
	 * stack_list_struct *slist, gpointer client_data
	 */
	void (*changed_cb)(gpointer, gpointer);
	gpointer client_data;

} stack_list_struct;

#define STACK_LIST(p)	((stack_list_struct *)(p))


extern void StackListAppend(
	stack_list_struct *slist,
	const gchar *name,
	const gchar *description,
	guint8 **icon_data,
	gpointer client_data,
	gint id,
	gbool allow_multiple, gbool stay_on_target
);
extern void StackListClear(stack_list_struct *slist);

extern void StackListItemAppendSrc(stack_list_struct *slist, gint id);
extern void StackListItemAppendTar(stack_list_struct *slist, gint id);
extern void StackListItemSetAllFromCacheSrc(stack_list_struct *slist);

extern void StackListItemRemoveByIDSrc(
	stack_list_struct *slist, gint id,
	gbool exclude_allowed_multiples
);
extern void StackListItemRemoveByIDTar(
	stack_list_struct *slist, gint id,
        gbool exclude_allowed_multiples
);

extern void StackListItemClearSrc(stack_list_struct *slist);
extern void StackListItemClearTar(stack_list_struct *slist);

extern gint *StackListItemGetSrc(stack_list_struct *slist, gint *total);
extern gint *StackListItemGetTar(stack_list_struct *slist, gint *total);


extern stack_list_struct *StackListNew(
        GtkWidget *parent,      /* A vbox. */
	const gchar *src_title, const gchar *tar_title,
        void (*changed_cb)(gpointer, gpointer),
        gpointer client_data
);
extern void StackListUpdateMenus(stack_list_struct *slist);
extern void StackListMap(stack_list_struct *slist);
extern void StackListUnmap(stack_list_struct *slist);
extern void StackListDelete(stack_list_struct *slist);


#endif	/* STACKLIST_H */
