/*
                       VMA Editor - Texture Handling
 */

#ifndef EDITORTEXTURE_H
#define EDITORTEXTURE_H

#include <sys/types.h>

#include <gtk/gtk.h>

#include "v3dtex.h"
#include "editor.h"


extern void EditorTexturePrimitiveRealize(
        ma_editor_struct *editor,
        mp_texture_select_struct *mp_texture_select,
        gbool rerealize
);
extern void EditorTexturePrimitiveUnrealize(
        ma_editor_struct *editor,
        mp_texture_select_struct *mp_texture_select
);

extern v3d_texture_ref_struct *EditorMatchTextureByName(
	ma_editor_struct *editor,
        const char *name,
	int *tex_num
);
extern int EditorTextureLoad(
        ma_editor_struct *editor,
	const char *name,
        const char *path,
	double priority
);
extern int EditorTextureLoadAll(ma_editor_struct *editor);

extern void EditorTextureChangeName(
        ma_editor_struct *editor,
        v3d_model_struct *model,
	const char *old_name, const char *new_name
);

extern void EditorTextureListDeleteAll(
	ma_editor_struct *editor
);


#endif	/* EDITORTEXTURE_H */

