/*
 * ===========================
 * VDK Builder
 * Version 1.0.3
 * Revision:
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str

  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_widclip.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_utils.h>
/*
into vdkb_design.cc
given a class name returns class id
*/
static char buff[256];
extern int WidgetClassId(char* class_name);
extern int MakeWidget(VDKBGuiForm* owner, int action_target, GdkEvent* ev);
/*
 */
/*
 */
// in vdkb_parser.cc
extern bool
CreateWidget(VDKBGuiForm* owner, char* classname,
	     char* buffer,VDKBParser& parser );

void
VDKBWidgetClipboard::CopyWidget(VDKObject* source)
{
  char* file = "$temp$.tmp";
  VDKBObject* vdkbsource =
  dynamic_cast<VDKBObject*>(source);
  // gets gui object owner (gui form)
  VDKBGuiForm* ownerform =
  dynamic_cast<VDKBGuiForm*>(source->Owner());
  // gets source widget container
  VDKBEventContainer* container =
  dynamic_cast<VDKBEventContainer*>(source->Parent());
  // make a temp file
  FILE* fp = fopen(file,"w+");
  // some pre-conditions checks
  g_return_if_fail (vdkbsource != NULL);
  g_return_if_fail (ownerform != NULL);
  g_return_if_fail (container != NULL);
  g_return_if_fail (fp != NULL);
  // writes widget info into .frm
  // does not copy signal connections however
  vdkbsource->WriteOnFrm(fp,container);
  vdkbsource->WriteOnFrmEnd(fp);
  // container deep copying not yet implemented
  // VDKBEventContainer* box;
  // if( (box = dynamic_cast<VDKBEventContainer*>(vdkbsource)) )
  // ownerform->RecursiveWriteBoxesOnFrm(vdkbsource,box->boxlist,fp);
  fclose(fp);
  // get a parser on that file
  VDKBParser parser(file);
  char arg[64];
  char* object;
  char obj_name[128];
  char obj_type[64];
  char* p = parser.Buffer();
  // scans .frm to reconstruct the widget copy
  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name) )
	    // using global scope resolution operator
	    ::CreateWidget(ownerform,obj_type,p,parser);
	  p+=strlen(object);
	  delete[] object;
	}
  }
  // retrieves new widget address
  // getting it from source parent child list
  // (it was added by CreateWidget)
  VDKObject *target = container->boxlist[container->boxlist.size()-1];
  // solve here the problem of widget name clush
  int counter = 0;
  const int NAMESIZE = 127;
  char nameclush[NAMESIZE+1];
  VDKBObject* vdkbtarget = dynamic_cast<VDKBObject*>(target);
  strcpy(nameclush,vdkbtarget->Name());
  while((ownerform->ChildWithName(nameclush) ||
	 ChildWithName(nameclush)) &&
	(strlen(nameclush) < (unsigned int) NAMESIZE)
	)
    {
      sprintf(buff,"%d",counter);
      nameclush[strlen(nameclush)-1] = '\0';
      strcat(nameclush,buff);
      counter++;
    }
  vdkbtarget->Name(nameclush);
  // cut new widget and put it onto clipboard stack top
  CutWidget(target);
  // delete temp file
  // call with global scope resolution to avoid
  // conflict with value list unlink().
  ::unlink(file);
}

/*
 */
VDKObject*
VDKBWidgetClipboard::ChildWithName(char* name)
{
VDKBWidgetClipboardIterator li(*this);
VDKString thisname = name;
VDKObject *found = (VDKObject*) NULL;
for(;li;li++)
  {
    VDKBObject* vdkobj = li.current().object;
    if(vdkobj && (vdkobj->Name() == thisname) )
      {
	found =  vdkobj->ObjectFromVDK();
	if(found)
	  break;
      }
  }
return found;
}
/*
copy a container
and all contained widgets
*/
void
VDKBWidgetClipboard::DeepCopyWidget(VDKObject* obj)
{
  // to be implemented
}

void
VDKBWidgetClipboard::RecursiveDeepCopyWidget(VDKObject* obj)
{
  // to be implemented
}
/*
 */
void
VDKBWidgetClipboard::CutWidget(VDKObject* cutted)
{
  VDKBGuiForm* ownerform =
    dynamic_cast<VDKBGuiForm*>(cutted->Owner());
  if(cutted->Parent() == ownerform->InnerBox())
    {
      if( ownerform->Application()->
	  MessageBox(APPNAME,
_("Uhmmm.., cutting the outermost container you\n\
won't be able to recover it easily. Confirm ?"),
		     MB_ICONQUESTION|MB_YESNO,
		     _(user_messages[user_ok]),
		     _(user_messages[user_no]),
		     9000
		     ) == IDNO)
	return;
	  
    }
    
  // makes a new clipboard item
  VDKBWidgetClipboardItem clipboardItem
    (
     dynamic_cast<VDKBObject*>(cutted),
     dynamic_cast<VDKBEventContainer*>(cutted->Parent()),
     cutted->Widget()
     );
  clipboardItem.parent = clipboardItem.widget->parent;
  if(clipboardItem.object &&
     clipboardItem.container
     )
    {
    if(GTK_IS_CONTAINER(clipboardItem.parent))
      {
	// remove from gtk+
	// referencing it or will be destroyed by gtk+
	// (will be unreferenced again on pasting)
	gtk_widget_ref (clipboardItem.widget);
	gtk_container_remove (
			      GTK_CONTAINER(clipboardItem.parent),
			      clipboardItem.widget);
	// remove from vdk owner
	// this is not really necessary since
	// will be added again to the same form
	if(ownerform)
	  {
	    ownerform->Items().remove(cutted);
	    // remove from vdkbuilder gui
	    clipboardItem.container->
	      boxlist.remove(cutted);
	    // notify to inspector that object is to be deleted
	    if(ownerform->Active == clipboardItem.object)
	      ownerform->Active = NULL;
	    ownerform->Changed = true;
	    VDKBProjectManager* prjman =
	      dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	    if(prjman && prjman->objInspector)
	      {
		// disable WI
		prjman->objInspector->SetActive(NULL);
		// reload WI
		prjman->objInspector->LoadTree(ownerform);
	      }
	    // add to clipboard (used as stack)
	    push(clipboardItem);
	  }
      }
  }
}
/*
 */
void
VDKBWidgetClipboard::PasteWidget(VDKObject* pasteWidget, int ndx,
				 bool reset_wi)
{

  if(size() > ndx)
    {
      VDKBGuiForm* ownerform =
	dynamic_cast<VDKBGuiForm*>(pasteWidget->Owner());
      if(!ownerform)
	return;
      /*
	pasting across forms isn't allowed
      */
      else 
	if(ownerform != 
	   (*WidgetClipboard)[ndx].object->ObjectFromVDK()->Owner())
	{
	  ownerform->Application()->
	    MessageBox(APPNAME,
		       _("Pasting across forms isn't allowed"),
		       MB_ICONINFORMATION|MB_OK,
		       _(user_messages[user_ok]),
		       NULL,
		       3000
		       );
	  return;
	}
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(ownerform->Active)
	{
	  // decide what add to owner, a widget or a
	  // container
	  VDKBEventContainer* container =
	    dynamic_cast<VDKBEventContainer*>((*this)[ndx].object);
	  if(container)
	    ownerform->AddContainerToSelf(container,NULL);
	  else
	    ownerform->AddToSelf((*this)[ndx].object,NULL);
	  if(reset_wi && prjman && prjman->objInspector)
	    {
	      // disable WI
	      prjman->objInspector->SetActive(NULL);
	      // reload WI
	      prjman->objInspector->LoadTree(ownerform);
	    }
	  if(reset_wi)
	    ownerform->Active = NULL;
	  ownerform->Changed = true;
	  gtk_widget_unref ((*this)[ndx].widget);
	  // * WARNING * this is potential inconsistency
	  // since cutting an widget and pasting it
	  // to a bin container could make the widget lost.
	  unlink(ndx);
	}
    }
}
