/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_pixmapbutton_h
#define _vdkb_pixmapbutton_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBPixmapButton: public VDKPixmapButton, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKEntry* caption, *pixfile;
  VDKCombo *relief;
  VDKLabelButton* set;
  VDKCheckButton* wrap;
  VDKLabelButton *shortname;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBPixmapButton(char* name,VDKForm* owner,char* pixfile,
		  char* label, char* tip = NULL);
  virtual ~VDKBPixmapButton() {}
  /*
  virtual VDKString&  Name(char* s = NULL) 
    {
      if(s)
	Caption = s;
      return VDKBObject::Name(s);
      
    }
  */
  virtual int Type() { return vdkbclass_pixmapbutton; }
  virtual char* VDKName() { return "VDKPixmapButton"; }
  virtual int isA() { return vdkbclass_pixmapbutton; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void PopMenu() { popmenu->Popup(); }
  // designer
  bool OnSetRelief(VDKObject*);
  bool OnSetCaption(VDKObject*);
  bool OnSetCaptionWrap(VDKObject*);
  bool OnSetGlyph(VDKObject*);
  bool OnSetShortName(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBPixmapButton);
  DECLARE_EVENT_LIST(VDKBPixmapButton);
};
#endif
