
#include <entries.h>
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(EntriesForm,VDKForm);
DEFINE_EVENT_LIST(EntriesForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(EntriesForm,VDKForm)
ON_SIGNAL(quit,clicked_signal,OnquitClick),
ON_SIGNAL(toggleEdit,clicked_signal,OntoggleEditClick),
ON_SIGNAL(normal,activate_signal,ShowText),
ON_SIGNAL(numeric,activate_signal,ShowText),
ON_SIGNAL(date,activate_signal,ShowText),
ON_SIGNAL(secret,activate_signal,ShowText),
ON_SIGNAL(normal,focus_out_signal,FocusOut),
ON_SIGNAL(numeric,focus_out_signal,FocusOut),
ON_SIGNAL(date,focus_out_signal,FocusOut),
ON_SIGNAL(secret,focus_out_signal,FocusOut)
END_SIGNAL_MAP
/*
main form setup
*/
void
EntriesForm::GUISetup(void)
{
	SetSize(252,152);
	Title = "Shows various entries";
vbox1 = new VDKBox(this,v_box);
Add(vbox1,0,1,1,0);
table0 = new VDKTable(this,4,2,true);
table0->RowSpacing = 2;
table0->ColSpacing = 2;
table0->SetSize(250,102);
vbox1->Add(table0,0,1,1,0);
vbox2 = new VDKBox(this,v_box);
table0->AddToCell(vbox2,0,0);
label0 = new VDKLabel(this,"Normal input");
vbox2->Add(label0,0,1,1,0);
vbox3 = new VDKBox(this,v_box);
table0->AddToCell(vbox3,0,1);
normal = new VDKEntry(this,0);
normal->Editable = true;
vbox3->Add(normal,0,1,1,0);
vbox4 = new VDKBox(this,v_box);
table0->AddToCell(vbox4,1,0);
label1 = new VDKLabel(this,"Numeric input");
vbox4->Add(label1,0,1,1,0);
vbox5 = new VDKBox(this,v_box);
table0->AddToCell(vbox5,1,1);
numeric = new VDKEntry(this,0);
numeric->Foreground = VDKRgb(34,139,34);
numeric->Editable = true;
vbox5->Add(numeric,0,1,1,0);
vbox6 = new VDKBox(this,v_box);
table0->AddToCell(vbox6,2,0);
label2 = new VDKLabel(this,"Date input");
vbox6->Add(label2,0,1,1,0);
vbox7 = new VDKBox(this,v_box);
table0->AddToCell(vbox7,2,1);
date = new VDKEntry(this,0);
date->NormalBackground = VDKRgb(135,206,250);
date->Editable = true;
vbox7->Add(date,0,1,1,0);
vbox8 = new VDKBox(this,v_box);
table0->AddToCell(vbox8,3,0);
label3 = new VDKLabel(this,"Secret input");
vbox8->Add(label3,0,1,1,0);
vbox9 = new VDKBox(this,v_box);
table0->AddToCell(vbox9,3,1);
secret = new VDKEntry(this,0);
secret->Editable = true;
vbox9->Add(secret,0,1,1,0);
separator0 = new VDKSeparator(this,h_separator);
vbox1->Add(separator0,0,0,0,0);
showtext = new VDKLabel(this," ");
showtext->Foreground = VDKRgb(0,0,128);
showtext->Justify =  (GtkJustification) 2;
vbox1->Add(showtext,0,1,1,0);
hbox11 = new VDKBox(this,h_box);
vbox1->Add(hbox11,0,1,1,0);
hbox11->BorderWidth(0);
quit = new VDKCustomButton(this,(char*) NULL,"_Quit",16,(GtkPositionType) 0);
hbox11->Add(quit,0,1,0,0);
toggleEdit = new VDKCustomButton(this,(char*) NULL,"Read only",32,(GtkPositionType) 0);
hbox11->Add(toggleEdit,0,1,0,0);
}

// do not remove this mark: #!#
// end of file:entries_gui.cc