/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABSTRACTBUTTON_H
#define ABSTRACTBUTTON_H
#include <vdk/vdkobj.h>

/*!
  \class VDKAbstractButton
  \brief This class provides a common base for different types of buttons

  This class and some of his subclasses can be better substituted 
  with VDKCustomButton and childs.
 */
class VDKAbstractButton: public VDKObject 
{
public:
    VDKReadWriteValueProp<VDKAbstractButton, GtkReliefStyle> Relief;

    VDKAbstractButton(VDKForm* owner);
    virtual ~VDKAbstractButton();
    virtual void SetForeground(VDKRgb, GtkStateType) {}
    virtual void SetFont(VDKFont*) {}

    void SetRelief(GtkReliefStyle style) {
        gtk_button_set_relief(GTK_BUTTON(widget), style);
    }

    GtkReliefStyle GetRelief() {
        return gtk_button_get_relief(GTK_BUTTON(widget));
    }
#ifdef USE_SIGCPLUSPLUS
 public:
    /*!
      Extended LS signal system:
      Received when button is clicked
     */
    VDKSignal0<void> OnButtonClicked;
    /*!
      Extended LS signal system:
      Received when button is pressed
     */
    VDKSignal0<void> OnButtonPressed;
    /*!
      Extended LS signal system:
      Received when mouse leaves button
     */
    VDKSignal0<void> OnButtonLeave;
 protected:
    /* This method establishes the connection to sigc-signals in
       a concrete subclass. Wid is the underlaying used gtk-widget 
    */
    static void make_gtksigc_connection(VDKAbstractButton* obj,
					GtkWidget* wid);
 private:
    static void _handle_clicked(GtkWidget* wid, gpointer obj);
    static void _handle_pressed(GtkWidget* wid, gpointer obj);
    static void _handle_leave(GtkWidget* wid, gpointer obj);
#endif
};

#endif
