/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * =========================== 
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/FileSaveAsDialog.h"
#include <unistd.h>
#include <config.h>

#ifdef VDKDEBUG
extern int objectC;
extern int objectD;
#endif
static char buff[256];
///////////////////////////////////////////////////
DEFINE_SIGNAL_MAP(VDKFileSaveAsDialog,VDKFileDialog)
  ON_SIGNAL(open,clicked_signal,SaveClick),
  ON_SIGNAL(filelist,select_row_signal,FileSelected),
  ON_SIGNAL(filetype,activate_signal,SetFileMask)
END_SIGNAL_MAP
///////////////////////////
//
//////////////////////////
bool VDKFileSaveAsDialog::CheckOverwrite(char* file)
{
char locbuff[256];
if (!access(file,F_OK))
  {
    sprintf(locbuff,"File: %s\nexists, overwrite it ?",file);
    int answer = 
      Application()->MessageBox("File SaveAs Dialog",
			      locbuff,
			      MB_YESNO | MB_ICONINFORMATION);
    return answer == IDYES;
  }
 else
   return true;
}
////////////////////////////
// response method
///////////////////////////
bool VDKFileSaveAsDialog::FileSelected(VDKObject*)
{
  int sel = filelist->Selected.Row();
  if(sel < 0) return true;
  filetype->Text = (char*) filelist->Tuples[sel][0];
  return true;
}
/*
 */
bool VDKFileSaveAsDialog::SaveClick(VDKObject*)
{
  sprintf(buff,"%s/%s",(char*) pcwd,(char*) filetype->Text);
  if(CheckOverwrite(buff))
    {
      selections->resize(1);
      VDKString s(buff);
      (*selections)[0] = s;
      Close();
    }
  return true;
}
/*
 */
bool VDKFileSaveAsDialog::SetFileMask(VDKObject*)
{
SaveClick(NULL);
return true;
}
/*
 */
VDKFileSaveAsDialog::VDKFileSaveAsDialog(VDKForm* owner,
		FileStringArray* selections,
		char* title, 
	      GtkWindowType display):
  VDKFileDialog(owner,selections,title,display)
{
  gtk_clist_set_selection_mode(GTK_CLIST(filelist->CustomWidget()),
			     GTK_SELECTION_SINGLE);
 filetypeLabel->Caption = "Save file as";
 open->Caption = "Save";
}

/* 
 */
VDKFileSaveAsDialog::~VDKFileSaveAsDialog()
{
}
/*
*/
 


  


