#include <stdio.h>		// for printf()
#include <iostream>
#include "../include/vdk/vdkstring.h"
#include <vector>

VDKString Funt(const VDKString& s)
{
	VDKString local(s);
	return local;
}

void test1()
{
	VDKString A;
	cout << "Default Constructor: VDKString A = " << A << endl;

	VDKString copyofA = A;
	cout << "Copying a null string : copyofA = A = " << copyofA << endl;

	VDKString B("world");
	cout << "const char* constructor: (VDKString B(world)) = " << B << endl;

	A = "hello";
	cout << "Assignment from const char*: (A = hello) = " << A << endl;

	VDKString C = A ;
	cout << "Assignment from const VDKString: (VDKString C = A ) = " << C << endl;
	char c = 'x';
	C = C + VDKString(c) ;
	cout << "char c = 'x' ;  C = "<< C << endl;
	cout << "Appending a char: C = C + VDKString(c) = " << C << endl;
	cout << "Prepending a char: C = VDKString(c) + C = " ;
	C = VDKString(c) + C ;
	cout << C << endl;

	cout << "Appending a char to null string : A = copyofA + c = " ;
	cout.flush();
	A = copyofA + VDKString(c) ;
	cout << A << endl;

	cout << "Prepending a char to null string : A = c + copyofA =";
	cout.flush();
	A = VDKString(c) + copyofA ;
	cout << A << endl;

	cout << "Test of [] operator: B = " << B << 
		" B[0] = " << B[0] << 
		" B[1] = " << B[1] << 
		" B[2] = " << B[2] << 
		" B[20] = " << B[20] << 
		endl;

	cout << "B.c_str() = " ;
	cout.flush();
	cout << B.c_str() << endl;

	cout << " VDKString + const char* : C = B + 'goozy' = ";
	cout.flush();
	C = B + "goozy";
	cout << C << endl;

	cout << " const char* + VDKString  : A = 'goozy' + B = ";
	cout.flush();
	A = "goozy" + B ;
	cout << A << endl;

	cout << " VDKString(NULL) + const char* : C = copyofA + 'goozy' = ";
	cout.flush();
	C = copyofA + "goozy";
	cout << C << endl;

	cout << " const char* + VDKString(NULL)  : A = 'goozy' + copyofA = ";
	cout.flush();
	A = "goozy" + copyofA ;
	cout << A << endl;

	cout << "Instantsiate a VDKString from a single character : ";

	VDKString E('a');
	cout << "E('a') = " << E << endl;

	cout << "Instantsiate a VDKString from a null character : ";
	VDKString F('\0');
	cout << "F(NULL) = " << F << endl;
	cout << "Assignment of a single character : ";
	F = 'b';
	cout << "F = 'b' = " << F << endl;

	cout << "A = " << A << endl;
	cout << "B = " << B << endl;
	cout << "F = " << F << endl;
	cout << "E = " << E << endl;

	cout << "expression test 1: A + B + F + E  = " << A + B + F + E << endl;
	cout << "expression test 2: A + B + \"FreakOut\" + E  = " << A + B + "FreakOut" + E << endl;
	cout << "expression test 3: A + VDKString('%') + \"FreakOut\" + E  = " << A + VDKString('%') + "FreakOut" + E << endl;
	
	A = "           Hello great world             ";
	cout << "A = '" << A << "'" << endl;
	// Trim test
	cout << "A.Trim() => A = '" << A.Trim() << "'" << endl;
	// DelSelection test
	cout << "A.DelSelection(6, 6) => A = " << A.DelSelection(6, 6) << endl;
	// CharCount test
	cout << "A.CharCount('o') = " << A.CharCount('o') << endl;
	// UpperCase test
	cout << "A.UpperCase() => A = " << A.UpperCase() << endl;
	// LowerCase test
	cout << "A.LowerCase() => A = " << A.LowerCase() << endl;
	// isEmpty test
	A = "";
	cout << "A = '', A.isEmpty() = " << A.isEmpty() << endl;
	A = "Hello world";
	cout << "A = 'Hello world', A.isEmpty() = " << A.isEmpty() << endl;
	// Sprintf test
	cout << "A = 'Hello world', A.Sprintf('%d char is left from %s', 0, 'previous string') => A = "
		<< A.Sprintf("%d char is left from %s", 0, "previous string") << endl;
	// Concatf test
	A = "Hello";
	cout << "A = 'Hello', A.Concatf(' %dth %s', 5, 'world') => A = " << A.Concatf(" %dth %s", 5, "world") << endl;
	// GetPart test
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(1, ',') = " << A.GetPart(1, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(0, ',') = " << A.GetPart(0, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(5, ',') = " << A.GetPart(5, ',') << endl;
	// GetFCharPos test
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetFCharPos(',') = " << A.GetFCharPos(',') << endl;
	// GetLCharPos test
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetLCharPos(',') = " << A.GetLCharPos(',') << endl;
	// StrtoDouble test
	A = "375265.653";
	// commented because cout round this to an integer
	//cout << "A = '375265.653', A.StrtoDouble() = " << A.StrtoDouble() << endl;
	printf("A = '375265.653', A.StrtoDouble() = %f\n", A.StrtoDouble());
	// StrtoInt test
	A = "375";
	cout << "A = '375', A.StrtoInt() = " << A.StrtoInt() << endl;
	// SubStr test
	A = "Hello great world";
	cout << "A = 'Hello great world', A.SubStr(6, 5) = " << A.SubStr(6, 5) << endl;
	// Cut test
	cout << "A.Cut(3) = " << A.Cut(3) << endl;
	// LPad test
	cout << "A.LPad(8, 'o') = " << A.LPad(8, 'o') << endl;
	// RPad test
	cout << "A.RPad(13, 'o') = " << A.RPad(13, 'o') << endl;
	// DoubleChar test
	A = "Don't do that";
	cout << "A.DoubleChar() => A = " << A.DoubleChar() << endl;
	// FormatDate test
	A = "12/25/2000";
	cout << "A = '12/25/2000'" << endl;
	cout << "A.FormatDate(0, ENG_DATE, INT_DATE) => A = " << A.FormatDate(0, ENG_DATE, INT_DATE) << endl;
	cout << "A.FormatDate('/', INT_DATE, EUR_DATE) => A = " << A.FormatDate('/', INT_DATE, EUR_DATE) << endl;
	cout << "A.FormatDate(0, EUR_DATE, ENG_DATE) => A = " << A.FormatDate(0, EUR_DATE, ENG_DATE) << endl;
	cout << "A.FormatDate('/', ENG_DATE, ENG_DATE) => A = " << A.FormatDate('/', ENG_DATE, ENG_DATE) << endl;
}


vector<VDKString> vectortest()
{

	cout << endl;
	cout << "STL Test... endl;" << endl;
	cout << "Making a vector of strings..." << endl;

	vector<VDKString> strings;

	strings.push_back(VDKString("AstringA"));
	strings.push_back(VDKString("BstringB"));
	strings.push_back(VDKString("CstringC"));
	strings.push_back(VDKString("DstringD"));
	strings.push_back(VDKString("EstringE"));
	strings.push_back(VDKString("FstringF"));
	strings.push_back(VDKString("GstringG"));

	cout << "Reading the vector using an iterator..." << endl;
	for(vector<VDKString>::iterator i= strings.begin(); i != strings.end(); i++)
	{
		cout << "*i = " << *i << endl;
	}
	cout << "Reading the vector using [] operator" << endl;
	for(unsigned int j = 0; j < strings.size(); j++)
	{
		VDKString s = strings[j];
		cout << "strings[ " << j << " ]  = " << s << endl;
	}

	return strings;
}


void DumpVDKStringVector(const vector<VDKString>& A)
{

	cout << "Reading the returned vector using an const iterator..." << endl;
	for(vector<VDKString>::const_iterator i= A.begin(); i != A.end(); i++)
	{
		cout << "i->c_str() = " << i->c_str() << endl;
	}
	cout << "Reading the returned vector using [] operator" << endl;
	for(unsigned int j = 0; j < A.size(); j++)
	{
		VDKString s = A[j];
		cout << "strings[ " << j << " ]  = " << s << endl;
	}
}

void stltest()
{
	vector<VDKString> A = vectortest();
	DumpVDKStringVector(A);

}

int main()
{
	test1();
	stltest();
}
/*

	cout << "C = " << C << endl;
	VDKString D = Funt(C);
	cout << "D = Funt(C) = " << D << endl;

	vector<VDKString> pile;
	pile.push_back(A);
	pile.push_back(B);
	pile.push_back(C);
	pile.push_back(D);
	pile.push_back(A);

	vector<VDKString> stack = pile;

	for(vector<VDKString>::iterator i = stack.begin(); i!= stack.end(); i++)
	cout << "*i = " << *i << endl;
}

*/	
