/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * Revision 0.1
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef VDKPOINTERS_STDBY_H
#define VDKPOINTERS_STDBY_H

template <class T, void (T::*destroy)()>
class VDKRefCountPtr
{
 protected:
  T   *referee;
  int refCount;
 public:
  VDKRefCountPtr(T* t): referee(t),refCount(1) {}
  virtual ~VDKRefCountPtr() { release(); }
  VDKRefCountPtr& operator=(VDKRefCountPtr& t)
    {
      release();
      join();
      return *this;
    }
  T* operator->() const { return referee; }
  operator T*() const { return referee; }
  T& operator*() const { return *referee; }
  
 private:
  void join(VDKRefCountPtr& t)
    {
      referee = t.referee;
      refCount = t.refCount;
      ++refCount;
    }

 protected:
  virtual void release()
    {
      --refCount;
      if(refCount == 0)
#ifdef VDKDEBUG
	{
	  printf("\ndestroying proxy:%p",referee);
	  fflush(stdout);
#endif
        ((*referee).*destroy)();
#ifdef VDKDEBUG
	}
#endif
    }
};

#include <vdk/colors.h>
#include <vdk/vdkfont.h>
#include <vdk/rawpixmap.h>
#include <vdk/forms.h>
#include <vdk/vdkobj.h>

///////////////////////////////
typedef VDKRefCountPtr<VDKColor,&VDKColor::Destroy> VDKColorPointer; 
typedef VDKRefCountPtr<VDKFont,&VDKFont::Destroy> VDKFontPointer;
typedef VDKRefCountPtr<VDKRawPixmap,&VDKRawPixmap::Destroy> 
                                                  VDKRawPixmapPointer; 
typedef VDKRefCountPtr<VDKForm,&VDKForm::Destroy> VDKFormPointer;
typedef VDKRefCountPtr<VDKObject,&VDKObject::Destroy> VDKObjectPointer;  
#endif


