/**********************************************************************
*
*    gp28.c
*    ======
*
*    This file is part of the VARKON Graphics  Library.
*    URL: http://www.varkon.com
*
*    plycud();    Make dashed curve polyline
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    (C)Microform AB 1984-1999, Johan Kjellander, johan@microform.se
*
***********************************************************************/

#include "../../DB/include/DB.h"
#include "../../IG/include/IG.h"
#include "../../GE/include/GE.h"
#include "../include/GP.h"
#include <math.h>

/*
***Berknar nsta u-vrde
*/
static short nextu(double ds);

/*
***Berknar nsta position
*/
static short nextp(double ug, double x[], double y[], double z[]);

/*
***Berknar nsta antal vektorer
*/
static short nextnv(double ug);

extern DBTmat actvym;
extern VY     actvy;
extern double curnog,gpgszx,k2x;
extern int    ncrdxy;
extern bool   pltflg,gpgenz;

/*
***Static-variabler.
*/

static double actl,actu,prevu,sl,sskala;
static int    k;
static int    nvec;
static GMSEG *segpek;
static GMCUR *curpek;

/*!******************************************************/

        short plycud(
        GMCUR *gmpost,
        GMSEG *segmnt,
        int   *n,
        double x[],
        double y[],
        double z[],
        char   a[])

/*      Bygger en streckad kurva i form av en 2D/3D-polyline.
 *
 *      In: 
 *         gmpost:      Pekare till curve-structure.
 *         segmnt:      Array med segment.
 *         n+1:         Offset till polylinjestart.
 *         x,y,z,a:     Arrayer fr resultat.
 *
 *      Ut:
 *         n:           Offset till sista vektorn i polylinjen
 *         x,y,z,a:     Koordinater och status hos vektorerna
 *                      i polylinjen.
 *
 *      FV:   0 = Ok.
 *           -1 = Fr liten eller fr stor strecklngd fr att synas.
 *
 *      (C)microform ab 9/1/92 J. Kjellander
 *
 *      7/3/92   Uppsnabbning, J. Kjellander
 *      16/6/93  Dynamiska segment, J. Kjellander
 *      31/1/94  k = *n+1, J. Kjellander
 *      5/12/94  Font=2, J. Kjellander
 *      9/1/96   Bytt vydist->gpgenz, J. Kjellander
 *      19961104 nsgr, J. Kjellander
 *
 ******************************************************!*/

  {
    short   status;
    int     i;
    double  ltot,ds,mfakt,uinc,stopl;
    bool    offseg;
    GMSEG  *prjseg;
    DBTmat  m1,m2;

/*
***Div initiering.
*/
    curpek = gmpost;           /* Pekare till kurv-posten */
    k      = *n+1;             /* Offset i polylinjen */
    sl     = curpek->lgt_cu;   /* Strecklngd */
    actu   = 0.0;              /* Aktuellt globalt parametervrde */
    prevu  = 0.0;              /* Fregende globala parametervrde */
    actl   = 0.0;              /* Aktuell relativ lngd */
    mfakt  = DASHRATIO;        /* Mellanrumsfaktor=0.25 */
    offseg = FALSE;            /* TRUE om ngot segm. har offset */
/*
***Skrmskala.
*/
    sskala = gpgszx/(actvy.vywin[2] - actvy.vywin[0]);
/*
***Om ngot av segmenten har offset r det en offset-kurva 
***och d skall kurvplanet transformeras till aktiv vy.
*/
    for ( i=0; i<curpek->nsgr_cu; ++i )
      {
      if ( (segmnt+i)->ofs != 0.0 )
        {
        if ( actvy.vy3d )
          {
          V3MOME(&curpek->csy_cu,&m1,sizeof(DBTmat));
          GEtform_inv(&actvym,&m2);
          GEtform_mult(&m1,&m2,&curpek->csy_cu);
          }
        offseg = TRUE;
        break;
        }
      }
/*
***Om 3D-vy, transformera segmenten till rtt vy och berkna
***nya lngder. Om inte, kolla om lngd behvs och berkna isfall.
***S r tex. fallet fr en 3D-cirkel i 2D-vy d vi anropas av gpplar().
***Om projicering behvs grs detta p en kopia av segmenten s att
***om det visar att det rcker med heldraget (fr stor eller liten
***streck-lngd) s skall inte de ursprungliga segmenten projiceras
***en gng till av gpplcu(). Fr att segmentlngder skall bli rtt
***och drmed strecklngder mste alla Z-koefficienter sttas till
***0 dvs. kta projicering. Fr en offset-kurva kan man dock inte
***gra p det viset eftersom man d frndrar kurvans form.
*/
    if ( actvy.vy3d )
      {
      prjseg = DBcreate_segments(curpek->nsgr_cu);
      for ( i=0; i < curpek->nsgr_cu; ++i )
        {
        GEtfseg_to_local(&segmnt[i],&actvym,&prjseg[i]);
        if ( !offseg  &&  !gpgenz )
          prjseg[i].c0z = prjseg[i].c1z = prjseg[i].c2z = prjseg[i].c3z = 0.0;
        }
      segpek = prjseg;
      }
    else
      {
      prjseg = NULL;
      segpek = segmnt;
      }
/*
***Berkna hela kurvans lngd. Om ingen projektion skett ovan och
***kurvan har samma grafiska som geometriska representation r detta
***viserligen redan gjort men hur ska vi veta det ???
*/
    GEarclength((DBAny *)curpek,segpek,&ltot);
/*
***Kommer strecken att synas p skrmen ? Om inte rita heldraget.
*/
    if ( ltot < (1.5+mfakt)*sl ) { status = -1; goto error; }
    if ( mfakt*sl*k2x < 1.0  &&  !pltflg ) { status = -1; goto error; }
/*
***Berkna relativ steglngd. 0 > ds > 1.
*/
    ds = sl/ltot;
/*
***Finns det plats ?
*/
    if ( k+2 > PLYMXV )
      {
      status = -1;
      goto error;
      }
/*
***Brja med en slckt frflyttning till kurvans startposition.
***actu = 0.
*/
    nextp(actu,x,y,z);
    a[k++] = INVISIBLE;
/*
***Sedan ett frsta tnt delstreck. Berkna frst nytt actu
***och sedan antal vektorer genom ett nextnv()-anrop mitt p.
*/
    if ( (status=nextu(ds)) < 0 )
      {
      status = -1;
      goto error;
      }
    nextnv(actu/2.0);
    uinc = actu/nvec;
/*
***Finns det plats ?
*/
    if ( k+nvec+2 > PLYMXV )
      {
      --k;
      status = -1;
      goto error;
      }
/*
***Generera.
*/
    for ( i=0; i<nvec; ++i )
      {
      prevu += uinc;
      nextp(prevu,x,y,z);
      a[k++] = VISIBLE;
      }
/*
***Vi str nu i slutet p det frsta del-strecket med actl och actu.
***Generera resten utom sista. Detta fortstter vi med s lnge vi
***befinner oss p tryggt avstnd frn slutet. Vad detta r beror p
***aktuell font. Med streckat r det (1 delstreck + 2 mellanrum)
***och med streckprickat r det (1 lngt streck + 1 mellanrum + 1 kort
***streck + 2 mellanrum).
*/
    if ( curpek->fnt_cu == 1 ) stopl = 1.0 - (1.0+2*mfakt)*ds;
    else                       stopl = 1.0 - (1.0+4*mfakt)*ds;

    while ( actl < stopl )
      {
/*
***Om det r streckprickat lgger vi nu in ett mellanrum + ett
***kort streck.
*/
      if ( curpek->fnt_cu != 1 )
        {
        if ( (status=nextu((2.0*mfakt)*ds)) < 0 )
          {
          status = -1;
          goto error;
          }
/*
***Vi approximerar mellanrummet med ett motsvarande steg i u.
*/
        prevu += (actu-prevu)/2.0;
        nextp(prevu,x,y,z);
        a[k++] = INVISIBLE;
/*
***Vi str nu i brjan av en eller flera tnda frflyttningar.
***Berkna erfoderligt antal vektorer fr delstrecket.
***Om de inte fr plats i polylinjen avslutar vi utan att rita
***klart.
*/
        nextnv((actu+prevu)/2.0);

        if ( k+nvec+2 >= PLYMXV )
         {
       --k;
         status = -1;
         goto error;
         }
/*
***Generera nvec tnda frflyttningar.
*/
        uinc = (actu-prevu)/nvec;

        for ( i=0; i<nvec; ++i )
          {
          prevu += uinc;
          nextp(prevu,x,y,z);
          a[k++] = VISIBLE;
          }
        }
/*
***Oavsett om det r streckat eller streckprickat r det nu dags att
***rkna upp actl och actu med (ett mellanrum + ett lngt streck).
*/
      if ( (status=nextu((1.0+mfakt)*ds)) < 0 )
        {
        status = -1;
        goto error;
        }
/*
***Vi approximerar mellanrummet med ett motsvarande steg i u.
*/
      prevu = actu - 1.0/(1.0+mfakt)*(actu-prevu);
      nextp(prevu,x,y,z);
      a[k++] = INVISIBLE;
/*
***Vi str nu i brjan av en eller flera tnda frflyttningar.
***Berkna erfoderligt antal vektorer fr delstrecket.
***Om de inte fr plats i polylinjen avslutar vi utan att rita
***klart.
*/
      nextnv((actu+prevu)/2.0);

      if ( k+nvec+2 >= PLYMXV )
       {
     --k;
       status = -1;
       goto error;
       }
/*
***Generera nvec tnda frflyttningar.
*/
      uinc = (actu-prevu)/nvec;

      for ( i=0; i<nvec; ++i )
        {
        prevu += uinc;
        nextp(prevu,x,y,z);
        a[k++] = VISIBLE;
        }
      }
/*
***Ett sista mellanrum.
*/
    if ( (status=nextu(ds*mfakt)) < 0 )
      {
      status = -1;
      goto error;
      }
    nextp(actu,x,y,z);
    a[k++] = INVISIBLE;
/*
***Nu gller det att avsluta p ett vettigt stt.
***Finns det tillrckligt med plats kvar gr vi ett
***till streck, annars frlnger vi fregende.
*/
    if ( 1.0 - actl < ds*mfakt )
      {
      k -= 1;
      actu = prevu;
      }
/*
***Hur mnga vektorer behvs fr det som r kvar ?
*/
    nextnv((curpek->nsgr_cu + actu)/2.0);
    if ( k+nvec+2 >= PLYMXV )
      {
      --k;
      status = -1;
      goto error;
      }
/*
***Sista delstrecket.
*/
    uinc = (curpek->nsgr_cu - actu)/nvec;

    for ( i=0; i<nvec; ++i )
      {
      actu += uinc;
      nextp(actu,x,y,z);
      a[k++] = VISIBLE;
      }
/*
***Nr allt r klart har k rknats upp en gng fr mycket.
*/
    k--;
/*
***Allt verkar ha gtt bra.
*/
    status = 0;
/*
***Hur mnga vektorer blev det ?
*/
   *n = k;
    ncrdxy = k+1;
/*
***Endside.
*/
    for ( i=k/2+1; i<=k; ++i ) a[i] = a[i] | ENDSIDE;
/*
***Ev. perspektiv.
*/
    if ( actvy.vydist != 0.0 ) gppstr(x,y,z);
/*
***Felutgng.
*/
error:
    if ( prjseg != NULL ) DBfree_segments(prjseg);

    return(status);
 }

/*********************************************************/
/*!******************************************************/

 static short nextu(
        double ds)

/*      Berknar nsta u-vrde.
 *
 *      In: ds = Storleken p nsta steg, i relativ bglngd.
 *
 *      Ut: prevu, actu, actl.
 *
 *      FV:   0 = Ok.
 *
 *      (C)microform ab 10/3/92 J. Kjellander
 *
 ******************************************************!*/

 {
   short status;

/*
***Stt fregende u = aktuellt u.
*/
   prevu = actu;
/*
***Rkna upp actl.
*/
   actl += ds;
/*
***Berkna ett nytt actu.
*/
   status = GE717((DBAny *)curpek,segpek,NULL,actl,&actu);

   if ( status < 0 ) return(status);

   actu -= 1.0;

   return(0);
 }

 /*******************************************************/
/*!******************************************************/

 static short nextp(
        double ug,
        double x[],
        double y[],
        double z[])

/*      Berknar nsta position.
 *
 *      In: ug    = Globalt u-vrde.
 *          x,y,z = Arrayer fr resultat.
 *
 *      Ut: x,y,z.
 *
 *      FV:   0 = Ok.
 *
 *      (C)microform ab 10/3/92 J. Kjellander
 *
 ******************************************************!*/

 {
   int   intu;
   gmflt out[16];

/*
***Vlj rtt segment.
*/
    if ( (intu=(int)HEL(ug)) == curpek->nsgr_cu ) intu -= 1;
/*
***Berkna koordinater.
*/
    GE107((GMUNON *)curpek,segpek+intu,ug-intu,(short)0,out);
    x[k] = out[0]; y[k] = out[1]; z[k] = out[2];
/*
***Slut.
*/
   return(0);

 }

 /*******************************************************/
/*!******************************************************/

 static short nextnv(
        double ug)

/*      Berknar nsta antal vektorer.
 *
 *      In: ug = Globalt u-vrde.
 *
 *      Ut: x,y,z.
 *
 *      FV:   0 = Ok.
 *
 *      (C)microform ab 10/3/92 J. Kjellander
 *
 ******************************************************!*/

 {
   int   intu;
   gmflt kappa,out[16];

/*
***Vlj rtt segment.
*/
    if ( (intu=(int)HEL(ug)) == curpek->nsgr_cu ) intu -= 1;
/*
***Berkna krkning.
*/
    GE107((GMUNON *)curpek,segpek+intu,ug-intu,(short)3,out);
    kappa = out[15]/sskala;
/*
***Antal vektorer.
***Som mtt p dsdu anvnds sl. Se gp8.c.
***I gp8() anvnds 0.2*SQRT(..... fr en tredjedel av ett segment.
***Hr r det d logiskt att ta 3 ggr. s mycket fr ett streck.
*/
    nvec = (int)(0.6*SQRT(kappa)*sl*sskala*curnog + 0.5);
    if (nvec < 1 ) nvec = 1;
/*
***Slut.
*/
   return(0);

 }

 /*******************************************************/
