/***************************************************************************
                          dcspy.cpp  -  description
                             -------------------
    begin                : Fre Nov 8 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qregexp.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qpopupmenu.h>
#include <qapplication.h>
#include <qcursor.h>
#include <qclipboard.h>

#include <dcconfig.h>
#include <dciconloader.h>
#include <dcmenuhandler.h>

#include "dcspy.h"

// for numeric sorted list view item
#include "dcwidget.h"

#include <dclib/cquerymanager.h>

/** */
DCSpy * g_pSpy = 0;

/** */
DCSpy::DCSpy(QWidget *parent, const char *name, int wflags) : DCDialogSpy(parent,name,wflags)
{
	// set default icon
	setIcon( g_pIconLoader->GetPixmap(eiSPY) );
	
	InitDocument();

	g_pSpy = this;
}

/** */
DCSpy::~DCSpy()
{
	g_pSpy = NULL;
	
	m_Timer.stop();
}

/** */
void DCSpy::InitDocument()
{
	StringMap * map;

	// restore settings
	if ( g_pConfig->GetMap("SPYVIEW",map) == TRUE )
	{
		if ( ((*map)["WIDTH"].toInt() > 0) && ((*map)["HEIGHT"].toInt() > 0) )
		{
			setGeometry( (*map)["X"].toInt(), (*map)["Y"].toInt(), (*map)["WIDTH"].toInt(), (*map)["HEIGHT"].toInt() );
		}
	}

	connect(PushButton_CLEAR, SIGNAL(clicked()), this, SLOT(slotClickedClear()) );
	
	connect( &m_Timer, SIGNAL(timeout()), this, SLOT(timerDone()) );
	
	connect(ListView_SPY, SIGNAL(contextMenuRequested( QListViewItem *, const QPoint &, int )), this, SLOT(slotContextMenuSpy( QListViewItem *, const QPoint &, int )) );
	
	m_Timer.start( 1000, TRUE );
}

/** */
void DCSpy::DeInitDocument()
{
	StringMap * map;

	// save search view settings
	g_pConfig->GetMap("SPYVIEW",map);

	(*map)["X"]         = QString().setNum(parentWidget()->x());
	(*map)["Y"]         = QString().setNum(parentWidget()->y());
	(*map)["WIDTH"]     = QString().setNum(width());
	(*map)["HEIGHT"]    = QString().setNum(height());
	(*map)["VISIBLE"]   = QString().setNum(isVisible());
	(*map)["MAXIMIZED"] = QString().setNum(isMaximized());
	(*map)["MINIMIZED"] = QString().setNum(isMinimized());
	(*map)["ENABLED"]   = QString().setNum(isEnabled());
}

/** */
void DCSpy::slotClickedClear()
{
	ListView_SPY->setEnabled(FALSE);
	ListView_SPY->clear();
	ListView_SPY->setEnabled(TRUE);
	ListView_SPY->triggerUpdate();
}

/** */
void DCSpy::timerDone()
{
	if ( CQueryManager::Instance() )
	{
		// update search stat
		TextLabel_SEARCHCOUNTACTIVE->setText( CString().setNum( CQueryManager::Instance()->GetStat(essCOUNTACTIVE)).Data() );
		TextLabel_SEARCHCOUNTPASSIVE->setText( CString().setNum( CQueryManager::Instance()->GetStat(essCOUNTPASSIVE)).Data() );
		TextLabel_SEARCHCOUNTREJECT->setText( CString().setNum( CQueryManager::Instance()->GetStat(essCOUNTREJECT)).Data() );
		TextLabel_SEARCHCOUNTERROR->setText( CString().setNum( CQueryManager::Instance()->GetStat(essCOUNTERROR)).Data() );
		TextLabel_RESULTCOUNT->setText( CString().setNum( CQueryManager::Instance()->GetStat(essRESULTCOUNT)).Data() );
		TextLabel_RESULTCOUNTERROR->setText( CString().setNum( CQueryManager::Instance()->GetStat(essRESULTCOUNTERROR)).Data() );
	}

	m_Timer.start( 1000, TRUE );
}

/** search */
void DCSpy::DC_Search( CMessageSearch * MessageSearch )
{
	QString s;
	QListViewItem *item;

	if ( CheckBox_ENABLESPY->isChecked() )
	{
		s = MessageSearch->m_sString.Data();
		s = s.replace( QRegExp("\\$"), " " );
		
		if ( (s.left(4) == "TTH:") && (CheckBox_HIDETTH->isChecked()) )
		{
			return;
		}
		
		if ( s.left(4) != "TTH:" )
		{
			s = s.lower();
		}
		
		if((item = ListView_SPY->findItem(s,0)))
		{
			DC_QListViewItem * myitem = (DC_QListViewItem*) item;
			myitem->myvalue++;
			item->setText(1,QString().setNum(myitem->myvalue));
			item->setText(2,QTime::currentTime().toString("hh:mm:ss"));
		}
		else
		{
			DC_QListViewItem * myitem = new DC_QListViewItem(ListView_SPY);
			
			myitem->myvalue = 1;
			myitem->mycol = 1;
			
			myitem->setText(0,s);
			myitem->setText(1,QString().setNum(myitem->myvalue));
			myitem->setText(2,QTime::currentTime().toString("hh:mm:ss"));
			
			ListView_SPY->insertItem(myitem);
		}
	}
}

/** */
void DCSpy::slotContextMenuSpy( QListViewItem* item, const QPoint & point, int column )
{
	QPopupMenu *m;
	int id;
	
	if ( item == 0 )
	{
		return;
	}
	
	m = new QPopupMenu(this);
	DCMenuHandler::InsertMenu( m, emiCOPY );
	
	id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == emiCOPY )
	{
		QApplication::clipboard()->setText(item->text(0));
	}
}
