#include "s3virgeglx.h"
#include "s3virgetri.h"

void s3virgeGouraudTriangle( GLcontext *ctx, GLuint e0, GLuint e1, GLuint e2, GLuint pv )
{
	const struct vertex_buffer *VB;
		
	LOCAL_VARS;
	
	s3virgeglx.c_gtriangles++;

	VB = ctx->VB;

	CULL_BACKFACE();
	SORT_VERTICES(); 
	SET_VARIABLES();	
	SET_XY();
	SET_DIR();
	SET_Z();

	colours = VB->Color[0]->data;
	scolours = VB->Spec[0];

	if ( ctx->TriangleCaps & DD_FLATSHADE ) {
		FLATSHADE_COLORS();
	} else {
		GOURAUD_COLORS();
	}
	
	if (s3virgeglx.dmaDriver == 0) {
		SEND_COLORS();
		SEND_VERTICES();
	} else {
		DMAGETPTR(17);
		DMAOUTREG((S3VIRGE_3DTRI_REG | S3VIRGE_3DTRI_GBX), 17);
		DMA_SEND_COLORS();
		DMA_SEND_VERTICES();
		DMAFINISH();
	}
}

void s3virgeTextureTriangle( GLcontext *ctx, GLuint e0, GLuint e1, GLuint e2, GLuint pv )
{
	const struct vertex_buffer *VB;
	
	LOCAL_TEX_VARS;
	LOCAL_VARS;

	if ((s3virgeglx.triHack & S3HACK_ZERO_SRCCOL) && !s3virgeglx.lightmapHack)
		return;  // ignore lightmaps for now
	
	s3virgeglx.c_ttriangles++;

	VB = ctx->VB;

	CULL_BACKFACE();
	SORT_VERTICES(); 
	SET_VARIABLES();	
	SET_XY();
	SET_DIR();
	SET_Z();

	SET_TEX_VARIABLES();
	SET_UVWD();

	colours = VB->Color[0]->data;
	scolours = VB->Spec[0];

	if ( ctx->TriangleCaps & DD_FLATSHADE ) {
		FLATSHADE_COLORS();
	} else {
		GOURAUD_COLORS();
	}

	if (s3virgeglx.dmaDriver == 0) {
		SEND_UVWD();
		SEND_COLORS();
		SEND_VERTICES();
	} else {
		DMAGETPTR(31);
		DMAOUTREG((S3VIRGE_3DTRI_REG | S3VIRGE_3DTRI_BASEV), 31);
		DMA_SEND_UVWD();
		DMA_SEND_COLORS();
		DMA_SEND_VERTICES();
		DMAFINISH();
	}

	
	if (s3virgeglx.triHack & S3HACK_ZERO_SRCCOL)
		return;
		
	if (!s3virgeglx.lightmapHack)
		return;
		
	if (t->maxLog2 <= 3 && (s3virgeglx.triHack & S3HACK_WHITE_TRI))
		return; // bad hack for exploding bits! :) 

	if ( (s3virgeglx.triHack & S3HACK_WHITE_TRI)) {
		if ( (s3virgeglx.triHack & S3HACK_WHITE_TRI_ALPHA) ) {
			/* Draw a white triangle on the same vertices. */
			WAITFIFOEMPTY(2);
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_DEST_BASE), (s3virgeDB->lightmapBufferBlock->ofs & 0x003FFFFF));
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_CMDSET), s3virgeglx.whitetri_cmd);
			deltarx = deltary = deltgbx = deltgby = 0;
			gbstart = (0xFF << 23) | (0xFF << 7);
			arstart = (0x0 << 23) | (0xFF << 7);
			SEND_UVWD();
			SEND_COLORS();
			SEND_VERTICES();
			WAITFIFOEMPTY(2);
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_DEST_BASE), (s3virgeDB->backBufferBlock->ofs & 0x003FFFFF));
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_CMDSET), s3virgeglx.currenttri_cmd);
		} else {
			/* Draw a white triangle on the same vertices. */
			WAITFIFOEMPTY(2);
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_DEST_BASE), (s3virgeDB->lightmapBufferBlock->ofs & 0x003FFFFF));
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_CMDSET), s3virgeglx.whitetri_cmd);
			deltarx = deltary = deltgbx = deltgby = 0;
			gbstart = (0xFF << 23) | (0xFF << 7);
			arstart = (0xFF << 23) | (0xFF << 7);
			SEND_COLORS();
			SEND_VERTICES();
			WAITFIFOEMPTY(2);
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_DEST_BASE), (s3virgeDB->backBufferBlock->ofs & 0x003FFFFF));
			OUTREG( (S3VIRGE_3DTRI_REG | S3VIRGE_CMDSET), s3virgeglx.currenttri_cmd);
		}
	}	
}