
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * GL Rendering Commands with Pixel Data
 * modified July 14, 1998 by Terence Ripperda (ripperda@engr.sgi.com)
 *
 * to help clean up some of the code and files I am splitting them 
 * up along more distinguished lines. This file corresponds to 
 * section 9.3.6 of the GLX Extension for OpenGL Protocol Specification
 * Version 1.2. This section describes the protocol for OpenGL calls
 * that Render and contain/transfer pixel data.
 */

#include <stdio.h>
#include "glxlib.h"
#include "pixel.h"


void __glx_Bitmap(GLsizei width, GLsizei height,
	      GLfloat xorig, GLfloat yorig,
	      GLfloat xmove, GLfloat ymove,
	      const GLubyte* bitmap)
{
    char* buffer = NULL;
    int s=GLX_image_size(width, height, GL_COLOR_INDEX, GL_BITMAP, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 5, 48, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_int(buffer, width);
    __GLX_PUT_int(buffer, height);
    __GLX_PUT_float(buffer, xorig);
    __GLX_PUT_float(buffer, yorig);
    __GLX_PUT_float(buffer, xmove);
    __GLX_PUT_float(buffer, ymove);
    __GLX_PUT_buffer(buffer, bitmap, width, height, 
                     GL_COLOR_INDEX, GL_BITMAP, s);
}

void __glx_DrawPixels(GLsizei width, GLsizei height,
		  GLenum format, GLenum type, const GLvoid*pixels)
{
    char* buffer = NULL;
    int s=GLX_image_size(width, height, format, type, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 173, 40, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_sizei(buffer, width);
    __GLX_PUT_sizei(buffer, height);
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    __GLX_PUT_buffer(buffer, pixels, width, height, format, type, s);
}


void __glx_PolygonStipple(const GLubyte* mask)
{
    char* buffer = NULL;
    int s=GLX_image_size(32, 32, GL_COLOR_INDEX, GL_BITMAP, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 102, 24, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_buffer(buffer, mask, 32, 32, GL_COLOR_INDEX, GL_BITMAP, s);
}


void __glx_TexImage1D(GLenum target, GLint level, GLint components,
		  GLsizei width, GLint border, GLenum format,
		  GLenum type, const GLvoid*pixels)
{
    char* buffer = NULL;
    int s=GLX_texture_size(width, 1, format, type, target, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 109, 56, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, level);
    __GLX_PUT_int(buffer, components);
    __GLX_PUT_sizei(buffer, width);
    __GLX_PUT_int(buffer, 0);
    __GLX_PUT_int(buffer, border);
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    if (pixels) {
        __GLX_PUT_buffer(buffer, pixels, width, 1, format, type, s);
    } else {
        /* It is legal to pass a null pointer to TexImage[12]D
	 * I'll just allocate a temp buffer and send that to the server
	 * instead. (This is how SGI's GLX implementation does it) */
        void *temp;
 
         temp = malloc(s);
	 if (!temp){
	     fprintf(stderr,"Out of memory\n");
	     return;
	}
        __GLX_PUT_buffer(buffer, temp, width, 1, format, type, s);
	free(temp);
    }
}


void __glx_TexSubImage1D(GLenum target, GLint level, GLint xoffset,
                  GLsizei width, GLenum format, GLenum type,
                  const GLvoid *pixels)
{
    char* buffer = NULL;
    int s=GLX_texture_size(width, 1, format, type, target, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 4099, 60, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, level);
    __GLX_PUT_int(buffer, xoffset);
    __GLX_PUT_int(buffer, 0);       /* y offset */
    __GLX_PUT_int(buffer, width);
    __GLX_PUT_int(buffer, 1);       /* height */
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    __GLX_PUT_int(buffer, 0);       /* unused */
    __GLX_PUT_buffer(buffer, pixels, width, 1, format, type, s);
}


void __glx_TexImage2D(GLenum target, GLint level, GLint components,
		  GLsizei width, GLsizei height, GLint border,
		  GLenum format, GLenum type, const GLvoid*pixels)
{
    char* buffer = NULL;
    int s=GLX_texture_size(width, height, format, type, target, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 110, 56, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, level);
    __GLX_PUT_int(buffer, components);
    __GLX_PUT_sizei(buffer, width);
    __GLX_PUT_sizei(buffer, height);
    __GLX_PUT_int(buffer, border);
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    if (pixels) {
        __GLX_PUT_buffer(buffer, pixels, width, height, format, type, s);
    } else {
        void *temp;
        temp = malloc(s);
	if (!temp){
	    fprintf(stderr,"Out of memory\n");
	    return;
	}
        __GLX_PUT_buffer(buffer, temp, width, height, format, type, s);
	free(temp);
    }
}


void __glx_TexSubImage2D(GLenum target, GLint level, GLint xoffset,
                  GLint yoffset, GLsizei width, GLsizei height,
                  GLenum format, GLenum type, const GLvoid *pixels) 
{
    char* buffer = NULL;
    int s=GLX_texture_size(width, height, format, type, target, GLCurrent->Unpack.Alignment);
    __GLX_GET_RENDER_BUFFER(buffer, 4100, 60, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_int(buffer, level);
    __GLX_PUT_int(buffer, xoffset);
    __GLX_PUT_int(buffer, yoffset);
    __GLX_PUT_int(buffer, width);
    __GLX_PUT_int(buffer, height);
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    __GLX_PUT_int(buffer, 0);
    __GLX_PUT_buffer(buffer, pixels, width, height, format, type, s);
}

