/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <errno.h>
#include "common.h"

static void gecosinfo(INFO *info)
{
    int i = 0;
    char *tmp, *buf;

    tmp = info->passwd->pw_gecos;

    info->gecos->name = NONE;
    info->gecos->office = NONE;
    info->gecos->officephone = NONE;
    info->gecos->homephone = NONE;

    while ((buf = strtok(tmp, ",")) != NULL) {
	switch (i) {
	    case 0:
		info->gecos->name = buf;
		break;
	    case 1:
		info->gecos->office = buf;
		break;
	    case 2:
		info->gecos->officephone = buf;
		break;
	    case 3:
		info->gecos->homephone = buf;
		break;
	    default:
		break;
	}

	tmp = NULL;
	i++;
    }

    return;
}

static void getgroups(INFO *info) {
    struct group *mygroup;
    GROUP *node;

    if ((info->group = (GROUP *) malloc(sizeof(GROUP))) == NULL) {
	perror("malloc");
	exit(errno);
    }

    node = info->group;

    if ((mygroup = getgrgid(info->passwd->pw_gid)) == NULL) {
	node->id = info->passwd->pw_gid;
	strncpy(node->name, UNKNOWN, sizeof(node->name));
	node->next = NULL;
	return;
    }

    node->id = mygroup->gr_gid;
    strncpy(node->name, mygroup->gr_name, sizeof(node->name));
    
    if ((node->next = (GROUP *) malloc(sizeof(GROUP))) == NULL) {
	perror("malloc");
	exit(errno);
    }

    node = node->next;
    
#ifdef HAVE_SETGROUPENT
    if (!setgroupent(1))
	fprintf(stderr, "could not keep group file open (will be slower)\n");
#else
    setgrent();
#endif

    group_info = 1;

    while ((mygroup = getgrent()) != NULL) {
	char *tmp;

	while (*mygroup->gr_mem) {
	    if (strncmp(*mygroup->gr_mem, info->passwd->pw_name,
			strlen(info->passwd->pw_name)) == 0) {
		
    		node->id = mygroup->gr_gid;
		strncpy(node->name, mygroup->gr_name, sizeof(node->name));
		
    		if ((node->next = (GROUP *) malloc(sizeof(GROUP))) == NULL) {
		    perror("malloc");
		    exit(errno);
		}

    		node = node->next;
	    }

	    tmp = *mygroup->gr_mem++;
	}
    }

    node->next = NULL;
    return;
}

void passwdinfo(INFO *info)
{
    int i;

    for (i = 0; i < ARRAYCNT(optspec); i++) {
	if (optspec[i] == 0)
	    break;

	switch (optspec[i]) {
	    case 'i':
		gecosinfo(info);
		break;
	    case 'g':
		getgroups(info);
		break;
	    default:
		break;
	}
    }

    return;
}
