/* l_lx_sh86.h -- created from l_lx_sh86.bin, 4403 (0x1133) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2006 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2006 Laszlo Molnar
   Copyright (C) 2000-2006 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define LINUX_I386SH_LOADER_SIZE    4403
#define LINUX_I386SH_LOADER_ADLER32 0xa08bedc6
#define LINUX_I386SH_LOADER_CRC32   0x64e997fc

unsigned char linux_i386sh_loader[4403] = {
232,  0,  0,  0,  0, 96,139,116, 36, 36,139,124, 36, 44,131,205,   /* 0x   0 */
255,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,   /* 0x  10 */
139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,   /* 0x  20 */
184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x  30 */
 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,   /* 0x  40 */
219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 49,201,   /* 0x  50 */
131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,  0,   /* 0x  60 */
137,197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,   /* 0x  70 */
219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,  0, 65,  1,   /* 0x  80 */
219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,   /* 0x  90 */
139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,  9,139,   /* 0x  a0 */
 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,253,  0,   /* 0x  b0 */
243,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,  0,  0,   /* 0x  c0 */
  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,138,  2, 66,   /* 0x  d0 */
136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,194,  4,   /* 0x  e0 */
137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,  0,  0,   /* 0x  f0 */
  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,   /* 0x 100 */
139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,   /* 0x 110 */
184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 120 */
 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,  1,   /* 0x 130 */
219,115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0, 72,  1,   /* 0x 140 */
219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0, 49,201,   /* 0x 150 */
131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,  0,   /* 0x 160 */
209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 170 */
219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x 180 */
117,  0, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x 190 */
  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,   /* 0x 1a0 */
  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,   /* 0x 1b0 */
  2,129,253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164,   /* 0x 1c0 */
 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,   /* 0x 1d0 */
  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,   /* 0x 1e0 */
  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,   /* 0x 1f0 */
233,  0,  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,   /* 0x 200 */
  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,   /* 0x 210 */
138,  7,114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,   /* 0x 220 */
238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 230 */
219,114,  0,  1,219,115, 11,117,  0,139, 30,131,238,252, 17,219,   /* 0x 240 */
114,  0, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,   /* 0x 250 */
235,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,   /* 0x 260 */
  0, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,   /* 0x 270 */
255,116,  0,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,   /* 0x 280 */
238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252,   /* 0x 290 */
 17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 2a0 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,   /* 0x 2b0 */
115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,   /* 0x 2c0 */
193,  2,129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,   /* 0x 2d0 */
164, 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,   /* 0x 2e0 */
118,  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,   /* 0x 2f0 */
139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,   /* 0x 300 */
207,233,  0,  0,  0,  0,255,210,  1,219,117,  2,255,210,144,232,   /* 0x 310 */
  0,  0,  0,  0,  1,219,116,  0,195,139, 30,131,238,252, 17,219,   /* 0x 320 */
195, 41,201, 17,201,114,  0, 17,201,114,  0, 17,201, 17,192, 72,   /* 0x 330 */
 17,192,131,233,  1,115,  0,141, 72, 15, 61,240,255,  0,  0,114,   /* 0x 340 */
  0,141,  4, 14, 80,233,  0,  0,  0,  0, 17,201, 17,201,131,193,   /* 0x 350 */
 13,235,  0,133,201,116,  0, 65,131,193,  8,235,  0, 41,201, 90,   /* 0x 360 */
 41,219,141, 65,  1,115,  0,114,  0,114,  0,114,  0,131,193,  2,   /* 0x 370 */
114,  0, 65,114,  5,233,  0,  0,  0,  0, 17,201,209,233,115,  1,   /* 0x 380 */
164,209,233,115,  2,102,165,243,165,141, 65,  1,235,  3,164,164,   /* 0x 390 */
164, 17,192,115,  0,131,232,  3,114, 11,193,224,  8,172,131,240,   /* 0x 3a0 */
255,116,  0,137,197, 17,201, 17,201,117,  0, 65, 17,201,115,  0,   /* 0x 3b0 */
131,193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,   /* 0x 3c0 */
131,253,252,119, 19,209,233,115,  1,164,209,233,115,  2,102,165,   /* 0x 3d0 */
243,165, 94,233,  0,  0,  0,  0,131,253,255,117,  5,172,243,170,   /* 0x 3e0 */
235,240,243,164,235,236,185, 84, 69, 88, 76,138,  7, 71, 44,232,   /* 0x 3f0 */
 60,  1,119,247,128, 63, 63,117,  0,139,  7,138, 95,  4,102,193,   /* 0x 400 */
232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,  7,   /* 0x 410 */
131,199,  5,136,216,226,  0,185, 84, 69, 88, 76,176,232,176,233,   /* 0x 420 */
242,174,117,  0,128, 63, 63,117,  0,139,  7,102,193,232,  8,134,   /* 0x 430 */
196,193,192, 16,134,196, 41,248,171,235,  0,139, 84, 36, 36,  3,   /* 0x 440 */
 84, 36, 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84, 36, 48,   /* 0x 450 */
137, 58,137, 68, 36, 28, 97,195, 94,252,173, 80, 84,186,  0,  0,   /* 0x 460 */
 64,  1,139, 66, 72,  1,208,131,194,116, 80,139, 74, 16,129,193,   /* 0x 470 */
  6, 16,  0,  0, 80, 80,106, 50,106,  7, 81, 80,137,227,106, 90,   /* 0x 480 */
 88,205,128,141,152,  3, 16,  0,  0,131,196, 24,173, 80,173, 86,   /* 0x 490 */
255,213, 88, 88,195, 93,232,189,255,255,255,  0, 76, 69, 88, 69,   /* 0x 4a0 */
 67, 48, 48, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,   /* 0x 4b0 */
  0, 76, 69, 88, 69, 67, 48, 50, 48,  0, 61,  0,  0,  0, 76, 69,   /* 0x 4c0 */
 88, 69, 67, 48, 49, 48,  0,  5,  0,  0,  0, 78, 50, 66, 83, 77,   /* 0x 4d0 */
 65, 49, 48,  0, 17,  0,  0,  0,  0,  0,  0,  0, 19,  0,  0,  0,   /* 0x 4e0 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66,   /* 0x 4f0 */
 70, 65, 83, 49, 48,  0, 20,  0,  0,  0,  0,  0,  0,  0, 22,  0,   /* 0x 500 */
  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78,   /* 0x 510 */
 50, 66, 70, 65, 83, 49, 49,  0, 22,  0,  0,  0, 78, 50, 66, 68,   /* 0x 520 */
 69, 67, 49, 48,  0, 28,  0,  0,  0, 78, 50, 66, 83, 77, 65, 50,   /* 0x 530 */
 48,  0, 39,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 78, 50,   /* 0x 540 */
 66, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 66, 70, 65,   /* 0x 550 */
 83, 50, 48,  0, 44,  0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,   /* 0x 560 */
 78, 50, 66, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 66,   /* 0x 570 */
 68, 69, 67, 50, 48,  0, 53,  0,  0,  0, 78, 50, 66, 83, 77, 65,   /* 0x 580 */
 51, 48,  0, 66,  0,  0,  0,  0,  0,  0,  0, 79,  0,  0,  0, 78,   /* 0x 590 */
 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70,   /* 0x 5a0 */
 65, 83, 51, 48,  0, 79,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,   /* 0x 5b0 */
  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,   /* 0x 5c0 */
  0,  0, 94,  0,  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,   /* 0x 5d0 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 94,  0,  0,  0,   /* 0x 5e0 */
  0,  0,  0,  0,112,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,   /* 0x 5f0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,142,  0,  0,  0, 78, 50, 66,   /* 0x 600 */
 68, 69, 67, 53, 48,  0,  0,  0,  0,  0, 78, 50, 66, 83, 77, 65,   /* 0x 610 */
 52, 48,  0,156,  0,  0,  0,  0,  0,  0,  0,169,  0,  0,  0, 78,   /* 0x 620 */
 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0, 78, 50, 66, 70,   /* 0x 630 */
 65, 83, 52, 48,  0,169,  0,  0,  0,  0,  0,  0,  0,173,  0,  0,   /* 0x 640 */
  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,  0,  0,   /* 0x 650 */
  0,  0,184,  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,   /* 0x 660 */
  0,  0,  0, 78, 50, 66, 68, 85, 77, 77, 49,  0,184,  0,  0,  0,   /* 0x 670 */
 78, 50, 66, 83, 77, 65, 53, 48,  0,184,  0,  0,  0, 78, 50, 66,   /* 0x 680 */
 70, 65, 83, 53, 48,  0,186,  0,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 690 */
 53, 48,  0,189,  0,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,  0,   /* 0x 6a0 */
198,  0,  0,  0,  0,  0,  0,  0,210,  0,  0,  0, 78, 50, 66, 68,   /* 0x 6b0 */
 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54,   /* 0x 6c0 */
 48,  0,210,  0,  0,  0,  0,  0,  0,  0,221,  0,  0,  0, 78, 50,   /* 0x 6d0 */
 66, 70, 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0,235,   /* 0x 6e0 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0,   /* 0x 6f0 */
 78, 50, 66, 70, 65, 83, 54, 49,  0,235,  0,  0,  0,  0,  0,  0,   /* 0x 700 */
  0,  1,  1,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,   /* 0x 710 */
  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0,  1,  1,  0,  0, 78,   /* 0x 720 */
 82, 86, 50, 66, 69, 78, 68,  0,  1,  1,  0,  0, 78, 50, 68, 83,   /* 0x 730 */
 77, 65, 49, 48,  0,  1,  1,  0,  0,  0,  0,  0,  0,  3,  1,  0,   /* 0x 740 */
  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50,   /* 0x 750 */
 68, 70, 65, 83, 49, 48,  0,  4,  1,  0,  0,  0,  0,  0,  0,  6,   /* 0x 760 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0,   /* 0x 770 */
 78, 50, 68, 70, 65, 83, 49, 49,  0,  6,  1,  0,  0, 78, 50, 68,   /* 0x 780 */
 68, 69, 67, 49, 48,  0, 12,  1,  0,  0, 78, 50, 68, 83, 77, 65,   /* 0x 790 */
 50, 48,  0, 23,  1,  0,  0,  0,  0,  0,  0, 25,  1,  0,  0, 78,   /* 0x 7a0 */
 50, 68, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 68, 70,   /* 0x 7b0 */
 65, 83, 50, 48,  0, 28,  1,  0,  0,  0,  0,  0,  0, 32,  1,  0,   /* 0x 7c0 */
  0, 78, 50, 68, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50,   /* 0x 7d0 */
 68, 68, 69, 67, 50, 48,  0, 37,  1,  0,  0, 78, 50, 68, 83, 77,   /* 0x 7e0 */
 65, 51, 48,  0, 50,  1,  0,  0,  0,  0,  0,  0, 63,  1,  0,  0,   /* 0x 7f0 */
 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0, 78, 50, 68,   /* 0x 800 */
 70, 65, 83, 51, 48,  0, 63,  1,  0,  0,  0,  0,  0,  0, 69,  1,   /* 0x 810 */
  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,  0,   /* 0x 820 */
  0,  0,  0, 78,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0,   /* 0x 830 */
 16,  0,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 78,  1,  0,   /* 0x 840 */
  0,  0,  0,  0,  0, 94,  1,  0,  0, 78, 50, 68, 68, 69, 67, 50,   /* 0x 850 */
 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,112,  1,  0,  0, 78, 50,   /* 0x 860 */
 68, 68, 69, 67, 54, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,146,   /* 0x 870 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0,   /* 0x 880 */
 78, 50, 68, 83, 77, 65, 52, 48,  0,160,  1,  0,  0,  0,  0,  0,   /* 0x 890 */
  0,173,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,   /* 0x 8a0 */
  0,  0, 78, 50, 68, 70, 65, 83, 52, 48,  0,173,  1,  0,  0,  0,   /* 0x 8b0 */
  0,  0,  0,177,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0,   /* 0x 8c0 */
 69,  0,  0,  0,  0,  0,  0,  0,188,  1,  0,  0, 78, 50, 68, 68,   /* 0x 8d0 */
 69, 67, 51, 48,  0, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77,   /* 0x 8e0 */
 49,  0,188,  1,  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,  0,188,   /* 0x 8f0 */
  1,  0,  0, 78, 50, 68, 70, 65, 83, 53, 48,  0,190,  1,  0,  0,   /* 0x 900 */
 78, 50, 68, 68, 69, 67, 53, 48,  0,193,  1,  0,  0, 78, 50, 68,   /* 0x 910 */
 83, 77, 65, 54, 48,  0,202,  1,  0,  0,  0,  0,  0,  0,214,  1,   /* 0x 920 */
  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78,   /* 0x 930 */
 50, 68, 70, 65, 83, 54, 48,  0,214,  1,  0,  0,  0,  0,  0,  0,   /* 0x 940 */
225,  1,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,  0,  0,  0,   /* 0x 950 */
  0,  0,  0,  0,  0,239,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49,   /* 0x 960 */
 48,  0,  0,  0,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,239,   /* 0x 970 */
  1,  0,  0,  0,  0,  0,  0,  5,  2,  0,  0, 78, 50, 68, 68, 69,   /* 0x 980 */
 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,   /* 0x 990 */
  0,  5,  2,  0,  0, 78, 82, 86, 50, 68, 69, 78, 68,  0,  5,  2,   /* 0x 9a0 */
  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  5,  2,  0,  0,  0,   /* 0x 9b0 */
  0,  0,  0,  7,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,   /* 0x 9c0 */
  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 48,  0,  8,  2,  0,   /* 0x 9d0 */
  0,  0,  0,  0,  0, 10,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49,   /* 0x 9e0 */
 48,  0,  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0, 10,   /* 0x 9f0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0, 16,  2,  0,  0,   /* 0x a00 */
 78, 50, 69, 83, 77, 65, 50, 48,  0, 27,  2,  0,  0,  0,  0,  0,   /* 0x a10 */
  0, 29,  2,  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  2,  0,   /* 0x a20 */
  0,  0, 78, 50, 69, 70, 65, 83, 50, 48,  0, 32,  2,  0,  0,  0,   /* 0x a30 */
  0,  0,  0, 36,  2,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0,   /* 0x a40 */
  0,  0,  0,  0, 78, 50, 69, 68, 69, 67, 50, 48,  0, 41,  2,  0,   /* 0x a50 */
  0, 78, 50, 69, 83, 77, 65, 51, 48,  0, 54,  2,  0,  0,  0,  0,   /* 0x a60 */
  0,  0, 67,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,   /* 0x a70 */
  0,  0,  0, 78, 50, 69, 70, 65, 83, 51, 48,  0, 67,  2,  0,  0,   /* 0x a80 */
  0,  0,  0,  0, 73,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x a90 */
  0, 31,  0,  0,  0,  0,  0,  0,  0, 82,  2,  0,  0, 78, 50, 69,   /* 0x aa0 */
 68, 69, 67, 51, 48,  0, 31,  0,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x ab0 */
 51, 48,  0, 82,  2,  0,  0,  0,  0,  0,  0, 98,  2,  0,  0, 78,   /* 0x ac0 */
 50, 69, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x ad0 */
113,  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,   /* 0x ae0 */
  0,  0,  0,  0,  0,131,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54,   /* 0x af0 */
 48,  0,  0,  0,  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,  0,177,   /* 0x b00 */
  2,  0,  0,  0,  0,  0,  0,190,  2,  0,  0, 78, 50, 69, 68, 69,   /* 0x b10 */
 67, 51, 48,  0, 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,   /* 0x b20 */
  0,190,  2,  0,  0,  0,  0,  0,  0,194,  2,  0,  0, 78, 50, 69,   /* 0x b30 */
 68, 69, 67, 51, 48,  0, 82,  0,  0,  0,  0,  0,  0,  0,205,  2,   /* 0x b40 */
  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 82,  0,  0,  0, 78,   /* 0x b50 */
 50, 69, 68, 85, 77, 77, 49,  0,205,  2,  0,  0, 78, 50, 69, 83,   /* 0x b60 */
 77, 65, 53, 48,  0,205,  2,  0,  0, 78, 50, 69, 70, 65, 83, 53,   /* 0x b70 */
 48,  0,207,  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,210,   /* 0x b80 */
  2,  0,  0, 78, 50, 69, 83, 77, 65, 54, 48,  0,219,  2,  0,  0,   /* 0x b90 */
  0,  0,  0,  0,231,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x ba0 */
  0,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54, 48,  0,231,  2,   /* 0x bb0 */
  0,  0,  0,  0,  0,  0,242,  2,  0,  0, 78, 50, 69, 70, 65, 83,   /* 0x bc0 */
 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 78,   /* 0x bd0 */
 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 70,   /* 0x be0 */
 65, 83, 54, 49,  0,  0,  3,  0,  0,  0,  0,  0,  0, 22,  3,  0,   /* 0x bf0 */
  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50,   /* 0x c00 */
 69, 68, 69, 67, 54, 48,  0, 22,  3,  0,  0, 78, 82, 86, 50, 69,   /* 0x c10 */
 69, 78, 68,  0, 22,  3,  0,  0, 67, 76, 49, 83, 77, 65, 49, 66,   /* 0x c20 */
  0, 22,  3,  0,  0, 67, 76, 49, 70, 65, 83, 49, 66,  0, 24,  3,   /* 0x c30 */
  0,  0, 67, 76, 49, 71, 69, 84, 49, 66,  0, 30,  3,  0,  0, 67,   /* 0x c40 */
 76, 49, 69, 78, 84, 69, 82,  0, 30,  3,  0,  0,  0,  0,  0,  0,   /* 0x c50 */
 36,  3,  0,  0, 67, 76, 49, 83, 84, 65, 82, 84,  0,  0,  0,  0,   /* 0x c60 */
  0, 67, 76, 49, 83, 77, 65, 49, 48,  0, 36,  3,  0,  0,  0,  0,   /* 0x c70 */
  0,  0, 40,  3,  0,  0, 67, 76, 49, 82, 76, 79, 65, 68,  0,  0,   /* 0x c80 */
  0,  0,  0, 67, 76, 49, 82, 76, 79, 65, 68,  0, 41,  3,  0,  0,   /* 0x c90 */
 67, 76, 49, 87, 73, 68, 48, 49,  0, 49,  3,  0,  0, 67, 76, 49,   /* 0x ca0 */
 87, 73, 68, 48, 50,  0, 51,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x cb0 */
 48, 51,  0, 53,  3,  0,  0,  0,  0,  0,  0, 55,  3,  0,  0, 67,   /* 0x cc0 */
 76, 49, 87, 73, 68, 49, 48,  0, 12,  0,  0,  0, 67, 76, 49, 87,   /* 0x cd0 */
 73, 68, 48, 52,  0, 55,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48,   /* 0x ce0 */
 53,  0, 57,  3,  0,  0,  0,  0,  0,  0, 59,  3,  0,  0, 67, 76,   /* 0x cf0 */
 49, 87, 73, 68, 49, 48,  0,  7,  0,  0,  0, 67, 76, 49, 87, 73,   /* 0x d00 */
 68, 48, 54,  0, 59,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 55,   /* 0x d10 */
  0, 61,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 56,  0, 64,  3,   /* 0x d20 */
  0,  0,  0,  0,  0,  0, 71,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x d30 */
 48, 54,  0,  2,  0,  0,  0,  0,  0,  0,  0, 81,  3,  0,  0, 67,   /* 0x d40 */
 76, 49, 87, 73, 68, 49, 48,  0, 15,  0,  0,  0,  0,  0,  0,  0,   /* 0x d50 */
 90,  3,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0, 18,  0,  0,   /* 0x d60 */
  0, 67, 76, 49, 87, 73, 68, 48, 57,  0, 90,  3,  0,  0, 67, 76,   /* 0x d70 */
 49, 87, 73, 68, 49, 48,  0, 92,  3,  0,  0,  0,  0,  0,  0, 99,   /* 0x d80 */
  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 55,  0,  2,  0,  0,  0,   /* 0x d90 */
  0,  0,  0,  0,103,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 56,   /* 0x da0 */
  0, 26,  0,  0,  0,  0,  0,  0,  0,109,  3,  0,  0, 67, 76, 49,   /* 0x db0 */
 84, 79, 80, 48, 55,  0,  2,  0,  0,  0, 67, 76, 49, 83, 84, 65,   /* 0x dc0 */
 82, 84,  0,109,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 48,  0,   /* 0x dd0 */
114,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 49,  0,117,  3,  0,   /* 0x de0 */
  0,  0,  0,  0,  0,119,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48,   /* 0x df0 */
 55,  0, 23,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 50,  0,119,   /* 0x e00 */
  3,  0,  0,  0,  0,  0,  0,121,  3,  0,  0, 67, 76, 49, 84, 79,   /* 0x e10 */
 80, 48, 55,  0, 22,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 51,   /* 0x e20 */
  0,121,  3,  0,  0,  0,  0,  0,  0,123,  3,  0,  0, 67, 76, 49,   /* 0x e30 */
 84, 79, 80, 48, 55,  0, 21,  0,  0,  0, 67, 76, 49, 84, 79, 80,   /* 0x e40 */
 48, 52,  0,123,  3,  0,  0,  0,  0,  0,  0,125,  3,  0,  0, 67,   /* 0x e50 */
 76, 49, 84, 79, 80, 48, 55,  0, 20,  0,  0,  0, 67, 76, 49, 84,   /* 0x e60 */
 79, 80, 48, 53,  0,128,  3,  0,  0,  0,  0,  0,  0,130,  3,  0,   /* 0x e70 */
  0, 67, 76, 49, 84, 79, 80, 48, 54,  0,  7,  0,  0,  0, 67, 76,   /* 0x e80 */
 49, 84, 79, 80, 48, 54,  0,131,  3,  0,  0,  0,  0,  0,  0,138,   /* 0x e90 */
  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 49,  0,  0,  0,  0,  0,   /* 0x ea0 */
 67, 76, 49, 84, 79, 80, 48, 55,  0,138,  3,  0,  0, 67, 76, 49,   /* 0x eb0 */
 79, 70, 70, 48, 49,  0,161,  3,  0,  0, 67, 76, 49, 79, 70, 70,   /* 0x ec0 */
 48, 50,  0,163,  3,  0,  0,  0,  0,  0,  0,165,  3,  0,  0, 67,   /* 0x ed0 */
 76, 49, 84, 79, 80, 48, 55,  0, 23,  0,  0,  0,  0,  0,  0,  0,   /* 0x ee0 */
179,  3,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0, 51,  0,  0,   /* 0x ef0 */
  0, 67, 76, 49, 79, 70, 70, 48, 51,  0,181,  3,  0,  0, 67, 76,   /* 0x f00 */
 49, 79, 70, 70, 48, 52,  0,183,  3,  0,  0,  0,  0,  0,  0,187,   /* 0x f10 */
  3,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0,  0,  0,  0,  0,   /* 0x f20 */
 67, 76, 49, 76, 69, 78, 48, 48,  0,187,  3,  0,  0, 67, 76, 49,   /* 0x f30 */
 76, 69, 78, 48, 49,  0,188,  3,  0,  0, 67, 76, 49, 76, 69, 78,   /* 0x f40 */
 48, 50,  0,190,  3,  0,  0,  0,  0,  0,  0,192,  3,  0,  0, 67,   /* 0x f50 */
 76, 49, 76, 69, 78, 48, 48,  0,  1,  0,  0,  0, 67, 76, 49, 67,   /* 0x f60 */
 79, 80, 89, 48,  0,195,  3,  0,  0,  0,  0,  0,  0,232,  3,  0,   /* 0x f70 */
  0, 67, 76, 49, 84, 79, 80, 48, 48,  0,  0,  0,  0,  0, 67, 76,   /* 0x f80 */
 49, 69, 78, 68,  0,246,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48,   /* 0x f90 */
 48,  0,246,  3,  0,  0, 67, 84, 67, 76, 69, 86, 69, 49,  0,  4,   /* 0x fa0 */
  4,  0,  0,  0,  0,  0,  0,  9,  4,  0,  0, 67, 65, 76, 76, 84,   /* 0x fb0 */
 82, 48, 48,  0,  5,  0,  0,  0, 67, 65, 76, 76, 84, 82, 48, 49,   /* 0x fc0 */
  0,  9,  4,  0,  0, 67, 84, 68, 85, 77, 77, 89, 49,  0, 14,  4,   /* 0x fd0 */
  0,  0, 67, 84, 66, 83, 72, 82, 48, 49,  0, 14,  4,  0,  0, 67,   /* 0x fe0 */
 84, 66, 82, 79, 82, 48, 49,  0, 18,  4,  0,  0, 67, 84, 66, 83,   /* 0x ff0 */
 87, 65, 48, 49,  0, 20,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48,   /* 0x1000 */
 50,  0, 25,  4,  0,  0,  0,  0,  0,  0, 39,  4,  0,  0, 67, 65,   /* 0x1010 */
 76, 76, 84, 82, 48, 48,  0, 10,  0,  0,  0, 67, 65, 76, 76, 84,   /* 0x1020 */
 82, 49, 48,  0, 39,  4,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,   /* 0x1030 */
  0, 44,  4,  0,  0, 67, 65, 76, 76, 84, 82, 69, 57,  0, 46,  4,   /* 0x1040 */
  0,  0, 67, 65, 76, 76, 84, 82, 49, 49,  0, 48,  4,  0,  0,  0,   /* 0x1050 */
  0,  0,  0, 52,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,   /* 0x1060 */
  5,  0,  0,  0, 67, 84, 67, 76, 69, 86, 69, 50,  0, 52,  4,  0,   /* 0x1070 */
  0,  0,  0,  0,  0, 57,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49,   /* 0x1080 */
 49,  0,  0,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 50,  0, 57,   /* 0x1090 */
  4,  0,  0, 67, 84, 68, 85, 77, 77, 89, 50,  0, 59,  4,  0,  0,   /* 0x10a0 */
 67, 84, 66, 83, 72, 82, 49, 49,  0, 59,  4,  0,  0, 67, 84, 66,   /* 0x10b0 */
 82, 79, 82, 49, 49,  0, 63,  4,  0,  0, 67, 84, 66, 83, 87, 65,   /* 0x10c0 */
 49, 49,  0, 65,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,   /* 0x10d0 */
 70,  4,  0,  0,  0,  0,  0,  0, 75,  4,  0,  0, 67, 65, 76, 76,   /* 0x10e0 */
 84, 82, 49, 48,  0,  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78,   /* 0x10f0 */
 68,  0, 75,  4,  0,  0, 76, 69, 88, 69, 67, 48, 49, 53,  0, 75,   /* 0x1100 */
  4,  0,  0, 76, 69, 88, 69, 67, 48, 50, 48,  0,104,  4,  0,  0,   /* 0x1110 */
 88, 84, 72, 69, 69, 78, 68, 88,  0,171,  4,  0,  0,255,255,255,   /* 0x1120 */
255,171,  4                                                        /* 0x1130 */
};
