/*
 *  update-cluster-removeline / Remove a host information based on 
 * a specified key.
 *  Copyright 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * portions of code taken from expat example code.
 * Original copyright notice follows: 
 */
/*$Id: update-cluster-remove.c,v 1.4 2001/08/08 02:48:39 dancer Exp $*/
/*****************************************************************
 * outline.c
 *
 * Copyright 1999, Clark Cooper
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the license contained in the
 * COPYING file that comes with the expat distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Read an XML document from standard input and print an element
 * outline on standard output.
 */

#include <stdio.h>
#include <expat.h>
#include <string.h>
#include <getopt.h>

#define BUFFSIZE 8192
const int depth_cluster = 1;
const int depth_host = 2;
const int depth_elements = 3;

typedef struct assoclist
{
  char * topic;
  char * content;  
  struct assoclist * next;
}assoclist;  


static char Buff[BUFFSIZE];
static int Depth ;
static char * current_node;
static assoclist * list_of_hostinfo = NULL;
static assoclist * remove_parameter_list = NULL;
static int switch_notfound = 0 ;/* optional NOT option*/

static 
void print_hostinfo_recurse(assoclist* list_of_hostinfo)
{
  if (list_of_hostinfo)
    {
      print_hostinfo_recurse(list_of_hostinfo->next);      
      printf ("    <%s>%s</%s>\n", 
	      list_of_hostinfo -> topic, 
	      list_of_hostinfo -> content, 
	      list_of_hostinfo -> topic);
    }
}


static void 
outofmemory(void)
{
  fprintf(stderr, "Out of memory\n");
  exit (EXIT_FAILURE);
}

static assoclist * 
add_to_list(assoclist * a, char * topic, char * content)
{
  assoclist * tmp = malloc (sizeof (assoclist));
  if (!tmp)
    outofmemory () ;
  tmp->topic = strdup(topic);
  tmp->content = strdup(content);  
  tmp->next = a;
  return tmp;  
}

void
start(void *data, const char *el, const char **attr)
{
  Depth++;

  if (Depth == depth_elements)
    current_node = strdup(el);
  if (Depth == depth_host)
    list_of_hostinfo = NULL;
}  /* End of start handler */

void
end(void *data, const char *el) {
  if (Depth == depth_elements)
    free (current_node);
  if (Depth == depth_host)
    {
      assoclist * tmp ;
      int match_found = 0;      

      tmp = list_of_hostinfo;

      while (tmp)
	{
	  assoclist * param = remove_parameter_list ;
	  while (param)
	    {
	      if (!strcmp(param->topic, tmp->topic))
		if (!strcmp(param->content, tmp->content))
		  match_found = 1;	      
	      param=param->next;
	    }
	  tmp=tmp->next;	  
	}
      if (((!match_found) && (!switch_notfound)) ||
	  (match_found && switch_notfound))
	{
	  printf("  <host>\n");
	  print_hostinfo_recurse(list_of_hostinfo);      
	  printf ("  </host>\n");
	}
      
      while (list_of_hostinfo)
	{
	  tmp = list_of_hostinfo -> next;
	  free (list_of_hostinfo -> topic);
	  free (list_of_hostinfo -> content);
	  free (list_of_hostinfo);
	  list_of_hostinfo = tmp;
	}
    }  
  Depth--;
}  /* End of end handler */

void
characterhandler (void * userdata, const XML_Char * s, int len)
{
  char * buf ;
  buf = malloc (len+1);
  if (!buf)
    outofmemory();  

  memcpy (buf, s, len);
  buf [len] = 0;
  if (Depth == depth_elements)
    {
      assoclist* tmp = malloc (sizeof (assoclist));
      if (!tmp)
	outofmemory();
      tmp -> topic = strdup (current_node);
      tmp -> content = strdup (buf);
      tmp -> next = list_of_hostinfo;
      list_of_hostinfo = tmp;
    }  
  free ( buf );
}

void parse_options ( int ac, char ** av)
{
  int index_point;  
  int c;			/* option */
  
  static struct option long_options[]=
  {
    {"ip", required_argument, 0, 'i'},
    {"master", no_argument, 0, 'm'},
    {"not", no_argument, 0, 'n'},
    {"help", no_argument, 0, 'n'},
    {0,0,0,0}
  };
  
  while((c = getopt_long (ac, av, "i:mnh", long_options, &index_point)) != -1)
    {
      switch (c)
	{
	case 'i':
	  remove_parameter_list = add_to_list (remove_parameter_list, "ip", optarg);
	  break;	  
	case 'm':
	  remove_parameter_list = add_to_list (remove_parameter_list, "notes", "master");
	  break;
	case 'n':
	  switch_notfound=1;
	  break;
	case 'h':
	  fprintf(stderr, "update-cluster-remove by Junichi Uekawa 2001\n\n"
		  "update-cluster-remove [--ip ipaddr] [--not] [--master]...\n"
		  "  parses an XML content, and outputs well-formatted XML output\n"
		  
		  "\n"
		  "please read the manpage for details.\n");
	  exit (1);
	  break;	  
	default:
	  fprintf (stderr, "Unhandled option specified\n");
	  break;	  
	}
    }
}


int
main(int argc, char **argv) 
{
  XML_Parser p = XML_ParserCreate(NULL);
  if (!p) 
    {
      fprintf(stderr, "Failed initialization of the parser\n");
      exit(EXIT_FAILURE);
    }

  parse_options(argc, argv);
  
  XML_SetElementHandler(p, start, end);
  XML_SetCharacterDataHandler(p, characterhandler);

  printf ("<?xml version =\"1.0\"?>\n"
	  "<!DOCTYPE cluster SYSTEM \"/usr/share/update-cluster/cluster.dtd\">\n"
	  "<cluster>\n");
  
  while(1)
    {
      int done;
      int len;
      
      len = fread(Buff, 1, BUFFSIZE, stdin);
      if (ferror(stdin)) 
	{
	  fprintf(stderr, "Read error\n");
	  exit(EXIT_FAILURE);
	}
      done = feof(stdin);
      
      if (! XML_Parse(p, Buff, len, done)) 
	{
	  fprintf(stderr, "Parse error at line %d:\n%s\n",
		  XML_GetCurrentLineNumber(p),
		  XML_ErrorString(XML_GetErrorCode(p)));
	  exit(EXIT_FAILURE);
      }
      
      if (done)
	break;
    }
  printf ("</cluster>\n");  

  exit (EXIT_SUCCESS);
}  

